/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.dom.internal;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.dom.Node;
import com.teamdev.jxbrowser.dom.XPathException;
import com.teamdev.jxbrowser.dom.XPathResult;
import com.teamdev.jxbrowser.dom.XPathResultType;
import com.teamdev.jxbrowser.dom.internal.rpc.EvaluationResult;
import com.teamdev.jxbrowser.dom.internal.rpc.IterateNextResponse;
import com.teamdev.jxbrowser.dom.internal.rpc.XPathBooleanResponse;
import com.teamdev.jxbrowser.dom.internal.rpc.XPathNodeResponse;
import com.teamdev.jxbrowser.dom.internal.rpc.XPathNumberResponse;
import com.teamdev.jxbrowser.dom.internal.rpc.XPathResultInfo;
import com.teamdev.jxbrowser.dom.internal.rpc.XPathResultStub;
import com.teamdev.jxbrowser.dom.internal.rpc.XPathSnapshotNodesResponse;
import com.teamdev.jxbrowser.dom.internal.rpc.XPathStringResponse;
import com.teamdev.jxbrowser.frame.internal.DomContext;
import com.teamdev.jxbrowser.internal.CloseableImpl;
import com.teamdev.jxbrowser.internal.rpc.ServiceConnectionImpl;
import com.teamdev.jxbrowser.internal.rpc.transport.Connection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

final class XPathResultImpl
extends CloseableImpl
implements XPathResult {
    private final DomContext domContext;
    private final EvaluationResult evaluationResult;
    private final ServiceConnectionImpl<XPathResultStub> rpc;

    XPathResultImpl(Connection connection, DomContext domContext, EvaluationResult evaluationResult) {
        Preconditions.checkNotNull(connection);
        Preconditions.checkNotNull(domContext);
        Preconditions.checkNotNull(evaluationResult);
        this.domContext = domContext;
        this.evaluationResult = evaluationResult;
        this.rpc = new ServiceConnectionImpl<XPathResultStub>(evaluationResult, connection, XPathResultStub::new);
    }

    @Override
    public XPathResultType type() {
        return this.evaluationResult.getType().toPublic();
    }

    @Override
    public double asNumber() {
        this.checkNotClosed();
        XPathNumberResponse response = (XPathNumberResponse)this.rpc.invoke(this.rpc.stub()::getNumber, this.info());
        if (response.getValueCase() == XPathNumberResponse.ValueCase.NUMBER_VALUE) {
            return response.getNumberValue();
        }
        throw new XPathException(response.getErrorMessage());
    }

    @Override
    public boolean isNumber() {
        return this.type() == XPathResultType.NUMBER;
    }

    @Override
    public String asString() {
        this.checkNotClosed();
        XPathStringResponse response = (XPathStringResponse)this.rpc.invoke(this.rpc.stub()::getString, this.info());
        if (response.getValueCase() == XPathStringResponse.ValueCase.STRING_VALUE) {
            return response.getStringValue();
        }
        throw new XPathException(response.getErrorMessage());
    }

    @Override
    public boolean isString() {
        return this.type() == XPathResultType.STRING;
    }

    @Override
    public boolean asBoolean() {
        this.checkNotClosed();
        XPathBooleanResponse response = (XPathBooleanResponse)this.rpc.invoke(this.rpc.stub()::getBoolean, this.info());
        if (response.getValueCase() == XPathBooleanResponse.ValueCase.BOOL_VALUE) {
            return response.getBoolValue();
        }
        throw new XPathException(response.getErrorMessage());
    }

    @Override
    public boolean isBoolean() {
        return this.type() == XPathResultType.BOOLEAN;
    }

    @Override
    public Optional<Node> asSingleNode() {
        this.checkNotClosed();
        XPathNodeResponse response = (XPathNodeResponse)this.rpc.invoke(this.rpc.stub()::getSingleNode, this.info());
        if (response.getValueCase() == XPathNodeResponse.ValueCase.NODE_INFO) {
            return this.domContext.toOptionalNode(response.getNodeInfo());
        }
        throw new XPathException(response.getErrorMessage());
    }

    @Override
    public boolean isSingleNode() {
        return this.type() == XPathResultType.FIRST_ORDERED_NODE || this.type() == XPathResultType.ANY_UNORDERED_NODE;
    }

    @Override
    public Optional<Node> iterateNext() {
        this.checkNotClosed();
        IterateNextResponse response = (IterateNextResponse)this.rpc.invoke(this.rpc.stub()::iterateNext, this.info());
        if (response.getValueCase() == IterateNextResponse.ValueCase.NODE_INFO) {
            return this.domContext.toOptionalNode(response.getNodeInfo());
        }
        throw new XPathException(response.getErrorMessage());
    }

    @Override
    public boolean isIterator() {
        return this.type() == XPathResultType.UNORDERED_NODE_ITERATOR || this.type() == XPathResultType.ORDERED_NODE_ITERATOR;
    }

    @Override
    public List<Node> asSnapshotNodes() {
        this.checkNotClosed();
        XPathSnapshotNodesResponse response = (XPathSnapshotNodesResponse)this.rpc.invoke(this.rpc.stub()::getSnapshotNodes, this.info());
        if (response.getValueCase() == XPathSnapshotNodesResponse.ValueCase.VALUE_NOT_SET) {
            return Collections.emptyList();
        }
        if (response.getValueCase() == XPathSnapshotNodesResponse.ValueCase.NODE_INFOS) {
            return Collections.unmodifiableList(this.domContext.toNodes(response.getNodeInfos().getNodeInfoList()));
        }
        throw new XPathException(response.getErrorMessage());
    }

    @Override
    public boolean isSnapshotNodes() {
        return this.type() == XPathResultType.ORDERED_NODE_SNAPSHOT || this.type() == XPathResultType.UNORDERED_NODE_SNAPSHOT;
    }

    private XPathResultInfo info() {
        return XPathResultInfo.newBuilder().setFrameId(this.domContext.frame().id()).setResultId(this.evaluationResult.getResultId()).build();
    }
}

