/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.engine.internal;

import com.teamdev.jxbrowser.deps.com.google.common.collect.ImmutableList;
import com.teamdev.jxbrowser.logging.Logger;
import java.util.Collection;

public final class AcceleratedLightweight {
    private static final ImmutableList<String> SWITCHES = ImmutableList.of("--disable-gpu", "--disable-gpu-compositing", "--enable-begin-frame-scheduling", "--software-rendering-fps=60");
    private static final String WARNING;

    public void ensureDisabled(Collection<String> commandLine) {
        if (commandLine.containsAll(SWITCHES)) {
            commandLine.removeAll(SWITCHES);
            Logger.warn(WARNING);
        }
    }

    static {
        StringBuilder builder = new StringBuilder();
        builder.append(System.lineSeparator()).append("You are trying to use the accelerated lightweight rendering mode introduced in JxBrowser 6.").append(System.lineSeparator()).append("In JxBrowser 7.10 and higher the off-screen rendering mode is accelerated by default.").append(System.lineSeparator()).append("The --disable-gpu and --disable-gpu-compositing switches will disable hardware acceleration.").append(System.lineSeparator()).append("If you need to disable GPU and enable software rendering, specify them separately from").append(System.lineSeparator()).append("the other switches in the set.").append(System.lineSeparator()).append("The following switches will be ignored:").append(System.lineSeparator());
        for (String chromiumSwitch : SWITCHES) {
            builder.append(chromiumSwitch).append(System.lineSeparator());
        }
        builder.append("It is recommended that you remove these switches from the engine options.");
        WARNING = builder.toString();
    }
}

