/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.engine.internal;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.engine.InvalidLicenseException;
import com.teamdev.jxbrowser.engine.LicenseException;
import com.teamdev.jxbrowser.engine.NoLicenseException;
import com.teamdev.jxbrowser.internal.licensing.LicenseVerificationStatus;

public final class LicenseExceptionFactory {
    public static final String EXPIRED_LICENSE_MSG = "This product version is incompatible with the license key. Read more at https://links.teamdev.com/jxbrowser-product-updates";
    public static final String EXPIRED_TRIAL_MSG = "Your free 30-day trial period is over. Read more at https://links.teamdev.com/jxbrowser-trial-period";
    public static final String EXPIRED_MCP_TRIAL_MSG = "Your license key has expired. To continue using the product, you may request a new evaluation license at https://teamdev.com/jxbrowser/#evaluate or purchase a commercial license at https://teamdev.com/jxbrowser/#licensing-and-pricing.";
    public static final String INVALID_PRODUCT_NAME_MSG = "Invalid product name.";
    public static final String INVALID_PRODUCT_BINDING_MSG = "The license is bound to a package that does not exist in this app.";
    public static final String INVALID_LICENSE_FORMAT_MSG = "Invalid license format.";
    public static final String BLOCKED_LICENSE_MSG = "The license has been revoked.";
    public static final String INVALID_LICENSE_TYPE_MSG = "Invalid license type.";
    public static final String INVALID_PRODUCT_VERSION_MSG = "Invalid product version.";
    public static final String INVALID_SIGNATURE_MSG = "Invalid license signature.";

    public static LicenseException create(LicenseVerificationStatus status) {
        Preconditions.checkArgument(status != LicenseVerificationStatus.VALID);
        return switch (status) {
            case LicenseVerificationStatus.EXPIRED -> new InvalidLicenseException(EXPIRED_LICENSE_MSG);
            case LicenseVerificationStatus.EVALUATION_EXPIRED -> new InvalidLicenseException(EXPIRED_TRIAL_MSG);
            case LicenseVerificationStatus.MCP_EVALUATION_EXPIRED -> new InvalidLicenseException(EXPIRED_MCP_TRIAL_MSG);
            case LicenseVerificationStatus.INVALID_TYPE -> new InvalidLicenseException(INVALID_LICENSE_TYPE_MSG);
            case LicenseVerificationStatus.INVALID_FORMAT -> new InvalidLicenseException(INVALID_LICENSE_FORMAT_MSG);
            case LicenseVerificationStatus.INVALID_PRODUCT_NAME -> new InvalidLicenseException(INVALID_PRODUCT_NAME_MSG);
            case LicenseVerificationStatus.INVALID_PRODUCT_VERSION -> new InvalidLicenseException(INVALID_PRODUCT_VERSION_MSG);
            case LicenseVerificationStatus.INVALID_PRODUCT_BINDING -> new InvalidLicenseException(INVALID_PRODUCT_BINDING_MSG);
            case LicenseVerificationStatus.INVALID_SIGNATURE -> new InvalidLicenseException(INVALID_SIGNATURE_MSG);
            case LicenseVerificationStatus.BLOCKED -> new InvalidLicenseException(BLOCKED_LICENSE_MSG);
            case LicenseVerificationStatus.NO_LICENSE -> new NoLicenseException();
            default -> new InvalidLicenseException("Unrecognized license verification error: " + String.valueOf(status));
        };
    }

    private LicenseExceptionFactory() {
    }
}

