/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.frame.internal;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.deps.com.google.protobuf.ByteString;
import com.teamdev.jxbrowser.frame.internal.DomContext;
import com.teamdev.jxbrowser.frame.internal.FrameImpl;
import com.teamdev.jxbrowser.internal.CloseableImpl;
import com.teamdev.jxbrowser.internal.CloseableMap;
import com.teamdev.jxbrowser.internal.rpc.PageContextId;
import com.teamdev.jxbrowser.js.internal.JsContext;
import com.teamdev.jxbrowser.js.internal.JsValue;
import com.teamdev.jxbrowser.js.internal.rpc.CollectionValue;
import com.teamdev.jxbrowser.js.internal.rpc.JsValues;
import com.teamdev.jxbrowser.js.internal.rpc.MapEntries;
import com.teamdev.jxbrowser.js.internal.rpc.MapEntry;
import com.teamdev.jxbrowser.js.internal.rpc.MapValue;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public final class PageContext
extends CloseableImpl {
    private static final CloseableMap<PageContextId, PageContext> pageContexts = CloseableMap.wrap(new ConcurrentHashMap());
    private final PageContextId id;
    private final DomContext domContext;
    private final JsContext jsContext;

    public static PageContext of(PageContextId id) {
        return Optional.ofNullable((PageContext)pageContexts.get(id)).orElseThrow(IllegalStateException::new);
    }

    private PageContext(FrameImpl frame, PageContextId pageContextId) {
        this.id = pageContextId;
        this.domContext = DomContext.newInstance(frame, this);
        this.jsContext = JsContext.newInstance(frame, this);
        pageContexts.put(this.id, this);
    }

    static PageContext newInstance(FrameImpl frame, PageContextId id) {
        Preconditions.checkNotNull(frame);
        return new PageContext(frame, id);
    }

    public CollectionValue serializeIterable(Iterable<?> iterable) {
        ByteString.Output stream = ByteString.newOutput();
        try {
            for (Object item : iterable) {
                JsValue.from(this.jsContext, item).impl().writeDelimitedTo(stream);
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to serialize the values.", e);
        }
        JsValues values = JsValues.newBuilder().setSerializedValues(stream.toByteString()).build();
        return CollectionValue.newBuilder().setSerializedValues(values).build();
    }

    public MapValue serializeMap(Map<?, ?> map) {
        ByteString.Output stream = ByteString.newOutput();
        try {
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                MapEntry.newBuilder().setKey(JsValue.from(this.jsContext, entry.getKey()).impl()).setValue(JsValue.from(this.jsContext, entry.getValue()).impl()).build().writeDelimitedTo(stream);
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to serialize the map values.", e);
        }
        MapEntries entries = MapEntries.newBuilder().setSerializedEntries(stream.toByteString()).build();
        return MapValue.newBuilder().setSerializedValues(entries).build();
    }

    public PageContextId id() {
        return this.id;
    }

    @Override
    public void close() {
        super.close();
        this.domContext.close();
        this.jsContext.close();
        pageContexts.remove(this.id);
    }

    public DomContext domContext() {
        return this.domContext;
    }

    public JsContext jsContext() {
        return this.jsContext;
    }
}

