/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.frame.internal.convert;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.deps.com.google.common.collect.ImmutableList;
import com.teamdev.jxbrowser.frame.internal.convert.AbstractValue;
import com.teamdev.jxbrowser.js.JsFunction;
import com.teamdev.jxbrowser.js.internal.JsFunctionImpl;
import com.teamdev.jxbrowser.js.internal.rpc.JsValue;
import java.util.List;

final class FunctionValue
extends AbstractValue {
    FunctionValue(JsValue jsValue) {
        super(jsValue);
        Preconditions.checkArgument(jsValue.getValueCase() == JsValue.ValueCase.FUNCTION_ID);
    }

    @Override
    public List<Class<?>> destinationTypes() {
        return ImmutableList.of(JsFunction.class);
    }

    @Override
    public <T> T toObject(Class<?> type) {
        Preconditions.checkNotNull(type);
        Preconditions.checkArgument(this.isConvertibleTo(type), "Cannot convert the value to: %s", type);
        return (T)this.getOrCreateJsObject(this.jsValue().getFunctionId(), JsFunctionImpl.class);
    }
}

