/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal;

import com.teamdev.jxbrowser.os.Environment;
import java.util.ArrayList;
import java.util.List;

public enum ChromiumArchiveName {
    WIN32("chromium-win32.7z"),
    WIN64("chromium-win64.7z"),
    WIN64_ARM("chromium-win64-arm.7z"),
    MAC("chromium-mac.7z"),
    MAC_ARM64("chromium-mac-arm.7z"),
    LINUX("chromium-linux64.7z"),
    LINUX_ARM64("chromium-linux64-arm.7z");

    private final String value;

    private ChromiumArchiveName(String value) {
        this.value = value;
    }

    public String value() {
        return this.value;
    }

    static List<ChromiumArchiveName> list() {
        ArrayList<ChromiumArchiveName> result = new ArrayList<ChromiumArchiveName>();
        if (Environment.isWindows()) {
            if (Environment.isArm()) {
                result.add(WIN64_ARM);
            } else {
                if (Environment.isWindows64()) {
                    result.add(WIN64);
                }
                result.add(WIN32);
            }
        }
        if (Environment.isMac()) {
            if (Environment.isAppleSilicon()) {
                result.add(MAC_ARM64);
            } else {
                result.add(MAC);
            }
        }
        if (Environment.isLinux() && Environment.is64Bit()) {
            if (Environment.isArm()) {
                result.add(LINUX_ARM64);
            } else {
                result.add(LINUX);
            }
        }
        return result;
    }

    public String toString() {
        return this.value;
    }
}

