/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal;

import com.teamdev.jxbrowser.VersionInfo;
import com.teamdev.jxbrowser.internal.ChromiumExecutable;
import com.teamdev.jxbrowser.internal.ChromiumProcessException;
import com.teamdev.jxbrowser.logging.Logger;
import java.io.File;
import java.nio.file.Path;
import java.util.Optional;

public final class ChromiumBundleMac {
    private ChromiumBundleMac() {
    }

    static Path helperExecutablePath(Path chromiumDir) {
        ChromiumExecutable executable = ChromiumExecutable.from(chromiumDir);
        Path chromiumVersionDir = ChromiumBundleMac.versionDir(chromiumDir);
        return chromiumVersionDir.resolve("Helpers").resolve(String.format("%s Helper.app", executable.name())).resolve("Contents").resolve("MacOS").resolve(String.format("%s Helper", executable.name())).toAbsolutePath();
    }

    public static Path librariesDir(Path chromiumDir) {
        Path chromiumVersionDir = ChromiumBundleMac.versionDir(chromiumDir);
        return chromiumVersionDir.resolve("Libraries").toAbsolutePath();
    }

    private static Path versionDir(Path chromiumDir) {
        ChromiumExecutable executable = ChromiumExecutable.from(chromiumDir);
        Path versionsDir = chromiumDir.resolve(String.format("%s.app", executable.name())).resolve("Contents").resolve("Frameworks").resolve("Chromium Framework.framework").resolve("Versions");
        return ChromiumBundleMac.findVersion(versionsDir);
    }

    private static Path findVersion(Path versionsDir) {
        String chromiumVersion = VersionInfo.chromiumVersion();
        if (chromiumVersion.equals("unknown") || chromiumVersion.equals("SNAPSHOT")) {
            Logger.warn("JxBrowser Chromium version is unknown, looking for any available version in the bundle");
            return ChromiumBundleMac.findAnyChromiumFrameworkVersion(versionsDir).orElseThrow(() -> new ChromiumProcessException(new RuntimeException("No versions found for Chromium Framework.framework")));
        }
        return versionsDir.resolve(chromiumVersion);
    }

    private static Optional<Path> findAnyChromiumFrameworkVersion(Path versionsDir) {
        File[] files = versionsDir.toFile().listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.isDirectory()) continue;
                return Optional.of(file.toPath());
            }
        }
        return Optional.empty();
    }
}

