/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal;

import com.teamdev.jxbrowser.VersionInfo;
import com.teamdev.jxbrowser.engine.EngineOptions;
import com.teamdev.jxbrowser.engine.RenderingMode;
import com.teamdev.jxbrowser.internal.ChromiumBundleMac;
import com.teamdev.jxbrowser.internal.ChromiumProcess;
import com.teamdev.jxbrowser.internal.ChromiumSwitches;
import com.teamdev.jxbrowser.os.Environment;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Optional;

public final class ChromiumProcessMac
extends ChromiumProcess {
    public static final String CF_PROCESS_PATH = "CFProcessPath";

    ChromiumProcessMac(int port, Path chromiumDir) {
        super(port, chromiumDir);
    }

    @Override
    protected void preProcessRun(ProcessBuilder processBuilder, EngineOptions options) throws IOException {
        super.preProcessRun(processBuilder, options);
        if (System.getenv().containsKey(CF_PROCESS_PATH)) {
            processBuilder.environment().remove(CF_PROCESS_PATH);
        }
    }

    @Override
    protected Optional<String> defaultCrashDumpDir() {
        return Optional.of(Environment.userHomeDir().resolve("Library").resolve("Application Support").resolve("JxBrowser").resolve(VersionInfo.version()).resolve("CrashReports").toAbsolutePath().toString());
    }

    @Override
    protected Collection<String> platformCommandLineArgs(EngineOptions engineOptions) {
        ChromiumSwitches switches = new ChromiumSwitches();
        switches.add("browser-subprocess-path", ChromiumBundleMac.helperExecutablePath(this.workingDir()).toString());
        switches.add("use-mock-keychain");
        if (engineOptions.renderingMode() == RenderingMode.OFF_SCREEN) {
            switches.add("disable-remote-core-animation");
        }
        return switches.toList();
    }
}

