/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal;

import com.teamdev.jxbrowser.internal.string.StringPreconditions;

public final class SystemProperties {
    public static final String LOGGING_LEVEL = "jxbrowser.logging.level";
    public static final String LOGGING_FILE = "jxbrowser.logging.file";
    public static final String CHROMIUM_DIR = "jxbrowser.chromium.dir";
    public static final String LICENSE_KEY = "jxbrowser.license.key";
    public static final String JS_ACCESSIBLE_DISABLED = "jxbrowser.jsaccessible.disabled";
    public static final String CHROMIUM_BINARIES_VERIFICATION_DISABLED = "jxbrowser.chromium.binaries.verification.disabled";
    public static final String CHROMIUM_BINARIES_CLEANUP_DISABLED = "jxbrowser.chromium.binaries.cleanup.disabled";
    public static final String JNI_EXTRACTION_ENABLED = "jxbrowser.jni.extraction.enabled";
    public static final String CRASH_DUMP_DIR = "jxbrowser.crash.dump.dir";
    public static final String NAVIGATION_TIMEOUT_IN_SECONDS = "jxbrowser.navigation.timeout.seconds";
    public static final String NESTED_UI_MESSAGE_LOOP_DISABLED = "jxbrowser.nested.ui.message.loop.disabled";
    public static final String JAVAFX_JNI_EMBEDDING_DISABLED = "jxbrowser.javafx.jni.embedding.disabled";
    public static final String LINUX_DEPS_CHECK_DISABLED = "jxbrowser.linux.deps.check.disabled";
    public static final String NATIVE_INPUT_ENABLED = "jxbrowser.native.input.enabled";
    public static final String LINUX_TOUCH_SCREEN_MODE_ENABLED = "jxbrowser.linux.touch.screen.mode.enabled";
    public static final String JNI_PRELOAD_ENABLED = "jxbrowser.jni.preload.enabled";

    public static boolean hasProperty(String propertyName) {
        StringPreconditions.checkNotNullEmptyOrBlank(propertyName);
        return System.getProperty(propertyName) != null;
    }

    public static String get(String propertyName, String defaultValue) {
        return System.getProperty(propertyName, defaultValue);
    }

    public static int getAsInt(String propertyName, int defaultValue) {
        StringPreconditions.checkNotNullEmptyOrBlank(propertyName);
        String strValue = System.getProperty(propertyName);
        if (strValue != null) {
            return Integer.parseInt(strValue);
        }
        return defaultValue;
    }

    public static boolean getAsBool(String propertyName, boolean defaultValue) {
        StringPreconditions.checkNotNullEmptyOrBlank(propertyName);
        String strValue = System.getProperty(propertyName);
        if (strValue != null) {
            return Boolean.parseBoolean(strValue);
        }
        return defaultValue;
    }

    private SystemProperties() {
    }
}

