/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.internal.string.StringPreconditions;
import java.util.Arrays;

public final class Version
implements Comparable<Version> {
    private final int[] numbers;

    public static Version parse(String version) {
        StringPreconditions.checkNotNullEmptyOrBlank(version, "The version parameter cannot be null or empty");
        Preconditions.checkArgument(version.matches("[0-9]+(\\.[0-9]+)*"), "Invalid version format");
        String[] parts = version.split("\\.", -1);
        int[] numbers = new int[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            numbers[i] = Integer.parseInt(parts[i]);
        }
        return new Version(numbers);
    }

    public Version(int ... numbers) {
        Preconditions.checkNotNull(numbers, "The numbers parameter cannot be null");
        this.numbers = numbers;
    }

    public int[] numbers() {
        return this.numbers;
    }

    public int major() {
        return this.numbers.length >= 1 ? this.numbers[0] : 0;
    }

    public int minor() {
        return this.numbers.length >= 2 ? this.numbers[1] : 0;
    }

    @Override
    public int compareTo(Version o) {
        if (o == null) {
            return 1;
        }
        int length = Math.max(this.numbers.length, o.numbers.length);
        for (int i = 0; i < length; ++i) {
            int thatPart;
            int thisPart = i < this.numbers.length ? this.numbers[i] : 0;
            int n = thatPart = i < o.numbers.length ? o.numbers[i] : 0;
            if (thisPart < thatPart) {
                return -1;
            }
            if (thisPart <= thatPart) continue;
            return 1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Version version = (Version)o;
        return Arrays.equals(this.numbers, version.numbers);
    }

    public int hashCode() {
        return Arrays.hashCode(this.numbers);
    }
}

