/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal.rpc;

import com.teamdev.jxbrowser.callback.Callback;
import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.deps.com.google.protobuf.Message;
import com.teamdev.jxbrowser.event.Event;
import com.teamdev.jxbrowser.event.Observer;
import com.teamdev.jxbrowser.event.internal.SubscriptionImpl;
import com.teamdev.jxbrowser.internal.CloseableImpl;
import com.teamdev.jxbrowser.internal.rpc.LocalServiceConnection;
import com.teamdev.jxbrowser.internal.rpc.Service;
import com.teamdev.jxbrowser.internal.rpc.ServiceConnection;
import com.teamdev.jxbrowser.internal.rpc.ServiceMethod;
import com.teamdev.jxbrowser.internal.rpc.stream.Interceptor;
import com.teamdev.jxbrowser.internal.rpc.stream.util.CallbackType;
import com.teamdev.jxbrowser.internal.rpc.stream.util.ParamsType;
import com.teamdev.jxbrowser.internal.rpc.transport.Connection;
import com.teamdev.jxbrowser.internal.rpc.transport.RpcCallExecutor;
import com.teamdev.jxbrowser.internal.rpc.transport.RpcCallback;
import com.teamdev.jxbrowser.internal.rpc.transport.SharedMemoryController;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public final class UniversalServiceConnection
extends CloseableImpl
implements ServiceConnection<LocalServiceConnection.FakeService> {
    private final Connection connection;
    private final Map<Class<?>, ServiceConnection<?>> serviceConnections;

    public static Builder with(Connection connection) {
        Preconditions.checkNotNull(connection);
        return new Builder(connection);
    }

    private UniversalServiceConnection(Connection connection, Map<Class<?>, ServiceConnection<?>> serviceConnections) {
        this.connection = connection;
        this.serviceConnections = serviceConnections;
    }

    public Connection connection() {
        return this.connection;
    }

    public <T> T stub(Class<T> cls) {
        return (T)this.serviceConnections.get(cls).stub();
    }

    @Override
    public LocalServiceConnection.FakeService stub() {
        throw new UnsupportedOperationException("The operation is not supported.");
    }

    @Override
    public <T extends Event> SubscriptionImpl on(Class<T> eventClass, Observer<T> observer) {
        for (ServiceConnection<?> serviceConnection : this.serviceConnections.values()) {
            if (!serviceConnection.canSubscribe(eventClass)) continue;
            return serviceConnection.on(eventClass, observer);
        }
        throw new IllegalStateException("The event type is not supported: " + String.valueOf(eventClass));
    }

    @Override
    public <T extends Event> void dispatch(T event) {
        for (ServiceConnection<?> serviceConnection : this.serviceConnections.values()) {
            if (!serviceConnection.canSubscribe(event.getClass())) continue;
            serviceConnection.dispatch(event);
            return;
        }
        throw new IllegalStateException("The event type is not supported: " + String.valueOf(event.getClass()));
    }

    @Override
    public <T> boolean canSetCallback(Class<T> paramsClass) {
        for (ServiceConnection<?> serviceConnection : this.serviceConnections.values()) {
            if (!serviceConnection.canSetCallback(paramsClass)) continue;
            return true;
        }
        return false;
    }

    @Override
    public <T> boolean canSubscribe(Class<T> eventClass) {
        for (ServiceConnection<?> serviceConnection : this.serviceConnections.values()) {
            if (!serviceConnection.canSubscribe(eventClass)) continue;
            return true;
        }
        return false;
    }

    @Override
    public <C extends Callback> C set(Class<C> callbackClass, C callback) {
        Preconditions.checkNotNull(callbackClass);
        Preconditions.checkNotNull(callback);
        Class requestClass = ParamsType.from(CallbackType.of(callbackClass)).type();
        for (ServiceConnection<?> serviceConnection : this.serviceConnections.values()) {
            if (!serviceConnection.canSetCallback(requestClass)) continue;
            return serviceConnection.set(callbackClass, callback);
        }
        throw new IllegalStateException("The callback type is not supported: " + String.valueOf(callbackClass));
    }

    @Override
    public <C extends Callback> Optional<C> get(Class<C> callbackClass) {
        Preconditions.checkNotNull(callbackClass);
        Class requestClass = ParamsType.from(CallbackType.of(callbackClass)).type();
        for (ServiceConnection<?> serviceConnection : this.serviceConnections.values()) {
            if (!serviceConnection.canSetCallback(requestClass)) continue;
            return serviceConnection.get(callbackClass);
        }
        throw new IllegalStateException("The callback type is not supported: " + String.valueOf(callbackClass));
    }

    @Override
    public <C extends Callback> C remove(Class<C> callbackClass) {
        Preconditions.checkNotNull(callbackClass);
        Class requestClass = ParamsType.from(CallbackType.of(callbackClass)).type();
        for (ServiceConnection<?> serviceConnection : this.serviceConnections.values()) {
            if (!serviceConnection.canSetCallback(requestClass)) continue;
            return serviceConnection.remove(callbackClass);
        }
        throw new IllegalStateException("The callback type is not supported: " + String.valueOf(callbackClass));
    }

    @Override
    public <T extends Message> void setCallbackInterceptor(Class<T> requestClass, Interceptor<T> interceptor) {
        Preconditions.checkNotNull(requestClass);
        Preconditions.checkNotNull(interceptor);
        for (ServiceConnection<?> serviceConnection : this.serviceConnections.values()) {
            if (!serviceConnection.canSetCallback(requestClass)) continue;
            serviceConnection.setCallbackInterceptor(requestClass, interceptor);
            return;
        }
        throw new IllegalStateException("The request type is not supported: " + String.valueOf(requestClass));
    }

    @Override
    public <T extends Message> void setEventInterceptor(Class<T> eventClass, Interceptor<T> interceptor) {
        Preconditions.checkNotNull(eventClass);
        Preconditions.checkNotNull(interceptor);
        for (ServiceConnection<?> serviceConnection : this.serviceConnections.values()) {
            if (!serviceConnection.canSubscribe(eventClass)) continue;
            serviceConnection.setEventInterceptor(eventClass, interceptor);
            return;
        }
        throw new IllegalStateException("The event type is not supported: " + String.valueOf(eventClass));
    }

    @Override
    public <RequestT extends Message, ResponseT extends Message> ResponseT invoke(ServiceMethod<RequestT, ResponseT> function, RequestT request) {
        Preconditions.checkState(!this.isClosed());
        RpcCallExecutor callExecutor = RpcCallExecutor.newInstance();
        return callExecutor.execute(request, function);
    }

    @Override
    public <RequestT extends Message, ResponseT extends Message> void invokeAsync(ServiceMethod<RequestT, ResponseT> function, RequestT request, RpcCallback<ResponseT> done) {
        Preconditions.checkState(!this.isClosed());
        SharedMemoryController controller = new SharedMemoryController();
        function.run(controller, request, response -> this.connection().rpcThread().submit(() -> {
            if (controller.failed()) {
                done.onError(new IllegalStateException(controller.errorText()));
            } else {
                done.onNext((Object)response);
            }
        }));
    }

    @Override
    public <RequestT extends Message, ResponseT extends Message> void invokeAsync(ServiceMethod<RequestT, ResponseT> function, RequestT request) {
        Preconditions.checkState(!this.isClosed());
        this.invokeAsync(function, request, new RpcCallback<ResponseT>(){});
    }

    @Override
    public void close() {
        for (ServiceConnection<?> serviceConnection : this.serviceConnections.values()) {
            serviceConnection.close();
        }
        super.close();
    }

    public static class Builder {
        private final Connection connection;
        private final Map<Class<?>, ServiceConnection<?>> serviceConnections;

        public Builder(Connection connection) {
            this.connection = connection;
            this.serviceConnections = new ConcurrentHashMap();
        }

        public <T extends Service> Builder and(ServiceConnection<T> rpc) {
            Preconditions.checkNotNull(rpc);
            this.serviceConnections.put(rpc.stub().getClass(), rpc);
            return this;
        }

        public UniversalServiceConnection build() {
            return new UniversalServiceConnection(this.connection, this.serviceConnections);
        }
    }
}

