/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal.rpc.transport;

import com.teamdev.jxbrowser.deps.com.google.protobuf.Message;
import com.teamdev.jxbrowser.internal.rpc.ServiceMethod;
import com.teamdev.jxbrowser.internal.rpc.transport.RpcCallExecutor;
import com.teamdev.jxbrowser.internal.rpc.transport.RpcThread;
import com.teamdev.jxbrowser.internal.rpc.transport.SharedMemoryController;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

final class RpcThreadCallExecutor
implements RpcCallExecutor {
    private final RpcThread rpcThread;

    RpcThreadCallExecutor(RpcThread rpcThread) {
        this.rpcThread = rpcThread;
    }

    @Override
    public <RequestT extends Message, ResponseT extends Message> ResponseT execute(RequestT request, ServiceMethod<RequestT, ResponseT> method) {
        Object key = new Object();
        RpcThread.TaskRunner taskRunner = this.rpcThread.enterNestedLoop(key);
        SharedMemoryController controller = new SharedMemoryController();
        CompletableFuture futureResponse = new CompletableFuture();
        method.run(controller, request, response -> {
            if (controller.failed()) {
                futureResponse.completeExceptionally(new IllegalStateException(controller.errorText()));
            } else {
                futureResponse.complete(response);
            }
            if (!this.rpcThread.isClosed()) {
                this.rpcThread.exitNestedLoop(key);
            }
        });
        taskRunner.processTasks();
        try {
            return (ResponseT)((Message)futureResponse.join());
        }
        catch (CompletionException e) {
            throw new IllegalStateException("Failed to receive the response.", e.getCause());
        }
    }
}

