/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal.rpc.transport;

import com.teamdev.jxbrowser.Closeable;
import com.teamdev.jxbrowser.deps.com.google.protobuf.InvalidProtocolBufferException;
import com.teamdev.jxbrowser.internal.rpc.ConnectionType;
import com.teamdev.jxbrowser.internal.rpc.Id;
import com.teamdev.jxbrowser.internal.rpc.RpcRequest;
import com.teamdev.jxbrowser.internal.rpc.RpcRequestId;
import com.teamdev.jxbrowser.internal.rpc.RpcResponse;
import com.teamdev.jxbrowser.internal.rpc.StreamData;
import com.teamdev.jxbrowser.internal.rpc.TextFormat;
import com.teamdev.jxbrowser.internal.rpc.stream.StreamChannel;
import com.teamdev.jxbrowser.internal.rpc.stream.StreamObserver;
import com.teamdev.jxbrowser.internal.rpc.transport.IpcLibrary;
import com.teamdev.jxbrowser.internal.rpc.transport.RpcCallback;
import com.teamdev.jxbrowser.internal.rpc.transport.SharedMemoryObserver;
import com.teamdev.jxbrowser.logging.Logger;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class SharedMemoryTransport
implements Closeable,
SharedMemoryObserver {
    private final String id;
    private final ConnectionType type;
    private final Map<RpcRequestId, StreamObserver<RpcResponse>> observers;
    private final IpcLibrary ipc = IpcLibrary.instance();
    private ConnectionState connectionState;

    SharedMemoryTransport(byte[] connectionData) {
        this.id = this.ipc.openConnection(connectionData, this, Thread.currentThread().getThreadGroup());
        if (this.id.isEmpty()) {
            throw new IllegalStateException("Failed to initialize the shared memory connection.");
        }
        this.type = ConnectionType.forNumber(IpcLibrary.instance().getConnectionType(this.id));
        this.observers = new ConcurrentHashMap<RpcRequestId, StreamObserver<RpcResponse>>();
        this.connectionState = ConnectionState.ALIVE;
    }

    @Override
    public void onDataAvailable(byte[] data) {
        try {
            StreamObserver<RpcResponse> observer;
            RpcResponse response = RpcResponse.parseFrom(data);
            SharedMemoryTransport.trace("Reading RPC response... ", response);
            RpcRequestId requestId = response.getRequestId();
            StreamObserver<RpcResponse> streamObserver = observer = response.hasStreamData() ? this.observers.get(requestId) : this.observers.remove(requestId);
            if (observer != null) {
                SharedMemoryTransport.trace("Calling RPC response observer... ", response);
                try {
                    observer.onNext(response);
                    SharedMemoryTransport.trace("Calling RPC response observer... [OK] ", response);
                }
                catch (Throwable t) {
                    Logger.error("Calling RPC response observer... [FAIL] {0}", t, () -> TextFormat.shortDebugString(response));
                }
            } else {
                SharedMemoryTransport.trace("No callback found for RPC response: ", response);
            }
        }
        catch (InvalidProtocolBufferException e) {
            Logger.error("Failed to parse response.", e);
        }
    }

    public String id() {
        return this.id;
    }

    public ConnectionType type() {
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(RpcRequest request, RpcCallback<RpcResponse> callback) {
        SharedMemoryTransport sharedMemoryTransport = this;
        synchronized (sharedMemoryTransport) {
            if (this.isClosed()) {
                callback.onError(new IllegalStateException("The connection has been closed."));
                return;
            }
            this.observers.put(request.getId(), callback);
        }
        this.ipc.sendData(this.id, request.toByteArray());
    }

    StreamChannel openChannel(String serviceName, String methodName, StreamObserver<StreamData> observer) {
        return new RpcStreamChannel(serviceName, methodName, observer);
    }

    @Override
    public synchronized void close() {
        if (this.isClosed()) {
            return;
        }
        this.ipc.closeConnection(this.id);
        this.observers.forEach((rpcRequestId, observer) -> {
            try {
                observer.onError(new IllegalStateException("The connection has been closed."));
            }
            catch (Exception e) {
                Logger.error("The response observer has thrown an exception.", e);
            }
        });
        this.observers.clear();
        this.connectionState = ConnectionState.CLOSED;
    }

    @Override
    public boolean isClosed() {
        return this.connectionState == ConnectionState.CLOSED;
    }

    private static void trace(String prefix, RpcResponse response) {
        Logger.trace(() -> prefix + TextFormat.shortDebugString(response));
    }

    private static enum ConnectionState {
        ALIVE,
        CLOSED;

    }

    private class RpcStreamChannel
    implements StreamChannel,
    RpcCallback<RpcResponse> {
        private final RpcRequest prototype;
        private final StreamObserver<StreamData> observer;

        private RpcStreamChannel(String serviceName, String methodName, StreamObserver<StreamData> observer) {
            this.observer = observer;
            this.prototype = RpcRequest.newBuilder().setId(RpcRequestId.newBuilder().setValue(Id.generate()).build()).setServiceName(serviceName).setMethodName(methodName).build();
            SharedMemoryTransport.this.observers.put(this.prototype.getId(), this);
        }

        @Override
        public int id() {
            return this.prototype.getId().getValue();
        }

        @Override
        public void write(StreamData data) {
            if (SharedMemoryTransport.this.isClosed()) {
                this.onError(new IllegalStateException("The connection is closed."));
                return;
            }
            RpcRequest request = this.prototype.toBuilder().setStreamData(data).build();
            SharedMemoryTransport.this.ipc.sendData(SharedMemoryTransport.this.id, request.toByteArray());
        }

        @Override
        public void close() {
            SharedMemoryTransport.this.observers.remove(this.prototype.getId());
        }

        @Override
        public void onNext(RpcResponse response) {
            this.observer.onNext(response.getStreamData());
        }

        @Override
        public void onError(Throwable t) {
            this.observer.onError(t);
        }
    }
}

