/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal.ui;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.deps.com.google.common.collect.ImmutableMap;
import com.teamdev.jxbrowser.internal.ui.ToolkitKey;
import com.teamdev.jxbrowser.ui.KeyCode;
import java.util.Map;

public final class ToolkitKeyCodes<K extends ToolkitKey<?, ?>> {
    private final ImmutableMap<K, KeyCode> matches;

    private ToolkitKeyCodes(Map<K, KeyCode> matches) {
        Preconditions.checkNotNull(matches);
        this.matches = ImmutableMap.copyOf(matches);
    }

    public static <K extends ToolkitKey<?, ?>> Builder<K> newBuilder() {
        return new Builder();
    }

    public KeyCode toKeyCode(K toolkitKey) {
        return this.matches.getOrDefault(toolkitKey, KeyCode.UNKNOWN);
    }

    public static class Builder<K extends ToolkitKey<?, ?>> {
        protected ImmutableMap.Builder<K, KeyCode> matches = ImmutableMap.builder();

        private Builder() {
        }

        public Builder<K> add(K toolkitKey, KeyCode keyCode) {
            this.matches.put(toolkitKey, keyCode);
            return this;
        }

        public ToolkitKeyCodes<K> build() {
            return new ToolkitKeyCodes<K>(this.matches.build());
        }
    }
}

