/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.net;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.deps.com.google.protobuf.ByteString;
import com.teamdev.jxbrowser.net.internal.rpc.File;
import java.nio.file.Path;
import java.util.Optional;

public interface File {
    public static Builder newBuilder() {
        return new Builder();
    }

    default public String name() {
        return ((com.teamdev.jxbrowser.net.internal.rpc.File)this).getFileName();
    }

    default public String contentType() {
        return ((com.teamdev.jxbrowser.net.internal.rpc.File)this).getContentType();
    }

    default public Optional<String> pathValue() {
        com.teamdev.jxbrowser.net.internal.rpc.File self = (com.teamdev.jxbrowser.net.internal.rpc.File)this;
        if (self.getValueCase() == File.ValueCase.FILE_PATH) {
            return Optional.of(self.getFilePath());
        }
        return Optional.empty();
    }

    default public Optional<byte[]> bytesValue() {
        com.teamdev.jxbrowser.net.internal.rpc.File self = (com.teamdev.jxbrowser.net.internal.rpc.File)this;
        if (self.getValueCase() == File.ValueCase.BYTES) {
            return Optional.of(self.getBytes().toByteArray());
        }
        return Optional.empty();
    }

    public static final class Builder {
        private final File.Builder builder = com.teamdev.jxbrowser.net.internal.rpc.File.newBuilder();

        private Builder() {
        }

        public Builder name(String name) {
            this.builder.setFileName(name);
            return this;
        }

        public Builder contentType(String contentType) {
            Preconditions.checkNotNull(contentType);
            this.builder.setContentType(contentType);
            return this;
        }

        public Builder pathValue(Path path) {
            Preconditions.checkNotNull(path);
            this.builder.setFilePath(path.toAbsolutePath().toString());
            return this;
        }

        public Builder bytesValue(byte[] bytes) {
            Preconditions.checkNotNull(bytes);
            this.builder.setBytes(ByteString.copyFrom(bytes));
            return this;
        }

        public File build() {
            return this.builder.build();
        }
    }
}

