/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.ui.event;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.ui.KeyCode;
import com.teamdev.jxbrowser.ui.KeyLocation;
import com.teamdev.jxbrowser.ui.KeyModifiers;
import com.teamdev.jxbrowser.ui.event.KeyEvent;
import com.teamdev.jxbrowser.ui.event.KeyEventConversion;
import com.teamdev.jxbrowser.ui.event.internal.rpc.KeyPressed;

public interface KeyPressed
extends KeyEvent {
    public static Builder newBuilder(KeyCode keyCode) {
        Preconditions.checkNotNull(keyCode);
        return new Builder(keyCode);
    }

    @Override
    default public KeyCode keyCode() {
        return KeyEventConversion.cast(this).getKeyCode().toPublic();
    }

    @Override
    default public KeyModifiers keyModifiers() {
        return KeyEventConversion.cast(this).getKeyModifiers();
    }

    @Override
    default public KeyLocation keyLocation() {
        return KeyEventConversion.cast(this).getKeyLocation().toPublic();
    }

    default public char keyChar() {
        String keyChar = KeyEventConversion.cast(this).getKeyChar();
        return keyChar.isEmpty() ? (char)'\u0000' : keyChar.charAt(0);
    }

    public static final class Builder {
        private final KeyPressed.Builder builder;

        private Builder(KeyCode keyCode) {
            this.builder = com.teamdev.jxbrowser.ui.event.internal.rpc.KeyPressed.newBuilder().setKeyCode(com.teamdev.jxbrowser.ui.internal.rpc.KeyCode.fromPublic(keyCode)).setKeyLocation(com.teamdev.jxbrowser.ui.internal.rpc.KeyLocation.STANDARD);
        }

        public Builder keyModifiers(KeyModifiers keyModifiers) {
            Preconditions.checkNotNull(keyModifiers);
            this.builder.setKeyModifiers((com.teamdev.jxbrowser.ui.event.internal.rpc.KeyModifiers)keyModifiers);
            return this;
        }

        public Builder keyLocation(KeyLocation keyLocation) {
            Preconditions.checkNotNull(keyLocation);
            this.builder.setKeyLocation(com.teamdev.jxbrowser.ui.internal.rpc.KeyLocation.fromPublic(keyLocation));
            return this;
        }

        public Builder keyChar(char keyChar) {
            this.builder.setKeyChar(String.valueOf(keyChar));
            return this;
        }

        public KeyPressed build() {
            return this.builder.build();
        }
    }
}

