/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.ui.internal;

import com.teamdev.jxbrowser.ui.Point;
import com.teamdev.jxbrowser.ui.internal.CursorConfiguration;
import com.teamdev.jxbrowser.ui.internal.rpc.CursorType;
import java.io.InputStream;
import java.net.URL;
import java.util.Optional;
import java.util.StringTokenizer;

public final class BuiltInCursors {
    private final CursorConfiguration configuration;

    public static BuiltInCursors instance() {
        return Holder.INSTANCE.cursors;
    }

    private BuiltInCursors(CursorConfiguration configuration) {
        this.configuration = configuration;
    }

    public Optional<BuiltInCursorData> find(CursorType type) {
        return this.configuration.cursorFileName(type).map(file -> {
            Point hotspot = this.configuration.cursorHotspotData(type).map(BuiltInCursors::parseHotspot).orElse(Point.empty());
            return new BuiltInCursorData((String)file, hotspot, type);
        });
    }

    private static Point parseHotspot(String hotspotData) {
        StringTokenizer st = new StringTokenizer(hotspotData, ",");
        if (st.countTokens() == 2) {
            try {
                int x = Integer.parseInt(st.nextToken());
                int y = Integer.parseInt(st.nextToken());
                return Point.of(x, y);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(String.format("Failed to parse the point: %s.", hotspotData), e);
            }
        }
        throw new IllegalArgumentException(String.format("Invalid point format: %s.", hotspotData));
    }

    private static enum Holder {
        INSTANCE;

        private final BuiltInCursors cursors = new BuiltInCursors(CursorConfiguration.newInstance());
    }

    public static final class BuiltInCursorData {
        private final String file;
        private final Point hotspot;
        private final CursorType type;

        private BuiltInCursorData(String file, Point hotspot, CursorType type) {
            this.file = file;
            this.hotspot = hotspot;
            this.type = type;
        }

        public URL resource() {
            return BuiltInCursorData.class.getResource(this.file);
        }

        public InputStream resourceAsStream() {
            return BuiltInCursorData.class.getResourceAsStream(this.file);
        }

        public Point hotspot() {
            return this.hotspot;
        }

        public CursorType type() {
            return this.type;
        }
    }
}

