/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.zoom.internal;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.engine.internal.EngineImpl;
import com.teamdev.jxbrowser.event.Observer;
import com.teamdev.jxbrowser.event.Subscription;
import com.teamdev.jxbrowser.internal.CloseableImpl;
import com.teamdev.jxbrowser.internal.rpc.ServiceConnectionImpl;
import com.teamdev.jxbrowser.profile.internal.ProfileImpl;
import com.teamdev.jxbrowser.zoom.ZoomLevel;
import com.teamdev.jxbrowser.zoom.ZoomLevels;
import com.teamdev.jxbrowser.zoom.event.ZoomLevelsEvent;
import com.teamdev.jxbrowser.zoom.internal.rpc.SetDefaultZoomLevelRequest;
import com.teamdev.jxbrowser.zoom.internal.rpc.ZoomLevelValue;
import com.teamdev.jxbrowser.zoom.internal.rpc.ZoomServiceStub;

public final class ZoomLevelsImpl
extends CloseableImpl
implements ZoomLevels {
    private final ProfileImpl profile;
    private final ServiceConnectionImpl<ZoomServiceStub> rpc;

    public ZoomLevelsImpl(ProfileImpl profile) {
        Preconditions.checkNotNull(profile);
        this.profile = profile;
        EngineImpl engine = profile.engine();
        this.rpc = new ServiceConnectionImpl<ZoomServiceStub>(profile.id(), engine.connection(), ZoomServiceStub::new);
    }

    @Override
    public ProfileImpl profile() {
        return this.profile;
    }

    @Override
    public ZoomLevel defaultLevel() {
        this.checkNotClosed();
        ZoomLevelValue zoomLevelValue = (ZoomLevelValue)this.rpc.invoke(this.rpc.stub()::getDefaultZoomLevel, this.profile.id());
        return ZoomLevel.of(zoomLevelValue.getZoomLevel());
    }

    @Override
    public void defaultLevel(ZoomLevel zoomLevel) {
        Preconditions.checkNotNull(zoomLevel);
        this.checkNotClosed();
        SetDefaultZoomLevelRequest request = SetDefaultZoomLevelRequest.newBuilder().setZoomLevel(ZoomLevelValue.newBuilder().setZoomLevel(zoomLevel.value()).build()).setProfileId(this.profile.id()).build();
        this.rpc.invoke(this.rpc.stub()::setDefaultZoomLevel, request);
    }

    @Override
    public <E extends ZoomLevelsEvent> Subscription on(Class<E> eventClass, Observer<E> observer) {
        return this.rpc.on(eventClass, observer);
    }

    @Override
    public void close() {
        this.rpc.close();
        super.close();
    }
}

