/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.compose.internal;

import androidx.compose.runtime.MutableState;
import androidx.compose.runtime.SnapshotStateKt;
import androidx.compose.runtime.Stable;
import com.teamdev.jxbrowser.browser.internal.AccessibilityNode;
import com.teamdev.jxbrowser.browser.internal.BrowserWidget;
import com.teamdev.jxbrowser.browser.internal.WebDialog;
import com.teamdev.jxbrowser.browser.internal.callback.CreateWebDialogCallback;
import com.teamdev.jxbrowser.browser.internal.callback.PaintCallback;
import com.teamdev.jxbrowser.browser.internal.rpc.CreateWebDialog;
import com.teamdev.jxbrowser.callback.Advisable;
import com.teamdev.jxbrowser.callback.Callback;
import com.teamdev.jxbrowser.ui.internal.rpc.Rect;
import com.teamdev.jxbrowser.view.compose.internal.OffScreenWidgetState;
import com.teamdev.jxbrowser.view.compose.internal.components.dialogs.CanvasWebDialogState;
import com.teamdev.jxbrowser.view.compose.internal.render.AwtWindowKt;
import com.teamdev.jxbrowser.view.compose.internal.render.RepaintBrowser;
import java.awt.Window;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.skia.Image;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0001\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001aH\u0016J\u0006\u0010\u001c\u001a\u00020\u001aJ\b\u0010\u001d\u001a\u00020\u001aH\u0002J\f\u0010\u001e\u001a\u00020\u001a*\u00020\u0010H\u0002J\b\u0010\u001f\u001a\u00020\u001aH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0018\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u0018\u0010\u0013\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0012R\"\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u000e\"\u0004\b\u0017\u0010\u0018\u00a8\u0006 "}, d2={"Lcom/teamdev/jxbrowser/view/compose/internal/CanvasWidgetState;", "Lcom/teamdev/jxbrowser/view/compose/internal/OffScreenWidgetState;", "widget", "Lcom/teamdev/jxbrowser/browser/internal/BrowserWidget;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "window", "Ljava/awt/Window;", "<init>", "(Lcom/teamdev/jxbrowser/browser/internal/BrowserWidget;Lkotlinx/coroutines/CoroutineScope;Ljava/awt/Window;)V", "image", "Landroidx/compose/runtime/MutableState;", "Lorg/jetbrains/skia/Image;", "getImage", "()Landroidx/compose/runtime/MutableState;", "accessibleWebView", "Lcom/teamdev/jxbrowser/browser/internal/AccessibilityNode;", "kotlin.jvm.PlatformType", "Lcom/teamdev/jxbrowser/browser/internal/AccessibilityNode;", "accessibleWebDialog", "webDialog", "Lcom/teamdev/jxbrowser/view/compose/internal/components/dialogs/CanvasWebDialogState;", "getWebDialog", "setWebDialog", "(Landroidx/compose/runtime/MutableState;)V", "show", "", "hide", "onDrawn", "clearImage", "addToWindow", "close", "compose"})
@Stable
@SourceDebugExtension(value={"SMAP\nCanvasWidgetState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CanvasWidgetState.kt\ncom/teamdev/jxbrowser/view/compose/internal/CanvasWidgetState\n+ 2 Async.kt\ncom/teamdev/jxbrowser/dsl/AsyncKt\n*L\n1#1,140:1\n44#2:141\n44#2:142\n61#2:143\n61#2:144\n*S KotlinDebug\n*F\n+ 1 CanvasWidgetState.kt\ncom/teamdev/jxbrowser/view/compose/internal/CanvasWidgetState\n*L\n66#1:141\n67#1:142\n132#1:143\n133#1:144\n*E\n"})
public final class CanvasWidgetState
extends OffScreenWidgetState {
    @NotNull
    private final BrowserWidget widget;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final Window window;
    @NotNull
    private final MutableState<Image> image;
    private final AccessibilityNode accessibleWebView;
    private final AccessibilityNode accessibleWebDialog;
    @NotNull
    private MutableState<CanvasWebDialogState> webDialog;
    public static final int $stable;

    public CanvasWidgetState(@NotNull BrowserWidget widget, @NotNull CoroutineScope scope, @NotNull Window window) {
        Advisable $this$register$iv;
        BrowserWidget browserWidget;
        Intrinsics.checkNotNullParameter((Object)widget, (String)"widget");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        super(widget, scope, window);
        this.widget = widget;
        this.scope = scope;
        this.window = window;
        this.image = SnapshotStateKt.mutableStateOf$default(null, null, (int)2, null);
        this.accessibleWebView = AccessibilityNode.create((BrowserWidget)this.widget);
        this.accessibleWebDialog = AccessibilityNode.create((BrowserWidget)this.widget);
        this.webDialog = SnapshotStateKt.mutableStateOf$default(null, null, (int)2, null);
        BrowserWidget $this$_init__u24lambda_u242 = browserWidget = this.widget;
        boolean bl = false;
        Advisable advisable = (Advisable)$this$_init__u24lambda_u242;
        Callback callback$iv = (Callback)new RepaintBrowser(this.image, this.scope);
        boolean $i$f$register = false;
        $this$register$iv.set(PaintCallback.class, callback$iv);
        $this$register$iv = (Advisable)$this$_init__u24lambda_u242;
        callback$iv = (Callback)((CreateWebDialogCallback)arg_0 -> CanvasWidgetState.lambda$2$lambda$1(this, arg_0));
        $i$f$register = false;
        $this$register$iv.set(CreateWebDialogCallback.class, callback$iv);
    }

    @NotNull
    public final MutableState<Image> getImage() {
        return this.image;
    }

    @NotNull
    public final MutableState<CanvasWebDialogState> getWebDialog() {
        return this.webDialog;
    }

    public final void setWebDialog(@NotNull MutableState<CanvasWebDialogState> mutableState) {
        Intrinsics.checkNotNullParameter(mutableState, (String)"<set-?>");
        this.webDialog = mutableState;
    }

    @Override
    public void show() {
        if (this.isShown()) {
            return;
        }
        super.show();
        AccessibilityNode accessibilityNode = this.accessibleWebView;
        Intrinsics.checkNotNullExpressionValue((Object)accessibilityNode, (String)"accessibleWebView");
        this.addToWindow(accessibilityNode);
        this.widget.requestLastRenderedFrame();
    }

    @Override
    public void hide() {
        if (!this.isShown()) {
            return;
        }
        super.hide();
        this.accessibleWebView.remove();
    }

    public final void onDrawn() {
        this.widget.onPainted();
    }

    private final void clearImage() {
        Image image = (Image)this.image.getValue();
        if (image != null) {
            Image it = image;
            boolean bl = false;
            if (!it.isClosed()) {
                it.close();
            }
        }
        this.image.setValue(null);
    }

    private final void addToWindow(AccessibilityNode $this$addToWindow) {
        long it = AwtWindowKt.getNativeId(this.window);
        boolean bl = false;
        $this$addToWindow.add(it, it);
    }

    @Override
    public void close() {
        BrowserWidget browserWidget;
        BrowserWidget $this$close_u24lambda_u245 = browserWidget = this.widget;
        boolean bl = false;
        Advisable $this$removeCallback$iv = (Advisable)$this$close_u24lambda_u245;
        boolean $i$f$removeCallback = false;
        $this$removeCallback$iv.remove(PaintCallback.class);
        $this$removeCallback$iv = (Advisable)$this$close_u24lambda_u245;
        $i$f$removeCallback = false;
        $this$removeCallback$iv.remove(CreateWebDialogCallback.class);
        this.accessibleWebView.remove();
        this.clearImage();
        super.close();
    }

    private static final Unit lambda$2$lambda$1$lambda$0(CanvasWidgetState this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.webDialog.setValue(null);
        this$0.accessibleWebDialog.remove();
        this$0.widget.focus();
        return Unit.INSTANCE;
    }

    private static final CreateWebDialog.Response lambda$2$lambda$1(CanvasWidgetState this$0, CreateWebDialog.Request params) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        WebDialog webDialog = new WebDialog(this$0.widget.browser(), params.getWebDialogId());
        Rect rect = params.getInitialBounds();
        Intrinsics.checkNotNullExpressionValue((Object)rect, (String)"getInitialBounds(...)");
        Rect rect2 = rect;
        CoroutineScope coroutineScope = this$0.scope;
        CanvasWebDialogState dialog = new CanvasWebDialogState(webDialog, (com.teamdev.jxbrowser.ui.Rect)rect2, (Function0<Unit>)((Function0)() -> CanvasWidgetState.lambda$2$lambda$1$lambda$0(this$0)), coroutineScope);
        BuildersKt.launch$default((CoroutineScope)this$0.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, dialog, null){
            int label;
            final /* synthetic */ CanvasWidgetState this$0;
            final /* synthetic */ CanvasWebDialogState $dialog;
            {
                this.this$0 = $receiver;
                this.$dialog = $dialog;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.this$0.getWebDialog().setValue((Object)this.$dialog);
                        AccessibilityNode accessibilityNode = CanvasWidgetState.access$getAccessibleWebDialog$p(this.this$0);
                        Intrinsics.checkNotNullExpressionValue((Object)accessibilityNode, (String)"access$getAccessibleWebDialog$p(...)");
                        CanvasWidgetState.access$addToWindow(this.this$0, accessibilityNode);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        return CreateWebDialog.Response.newBuilder().build();
    }

    public static final /* synthetic */ void access$addToWindow(CanvasWidgetState $this, AccessibilityNode $receiver) {
        $this.addToWindow($receiver);
    }

    public static final /* synthetic */ AccessibilityNode access$getAccessibleWebDialog$p(CanvasWidgetState $this) {
        return $this.accessibleWebDialog;
    }
}

