/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.compose.internal.dnd;

import androidx.compose.runtime.internal.StabilityInferred;
import com.teamdev.jxbrowser.browser.internal.BrowserWidget;
import com.teamdev.jxbrowser.os.Environment;
import com.teamdev.jxbrowser.view.compose.internal.dnd.ChromiumDragHandler;
import com.teamdev.jxbrowser.view.compose.internal.dnd.ChromiumDropTarget;
import com.teamdev.jxbrowser.view.compose.internal.dnd.CustomDataSupport;
import com.teamdev.jxbrowser.view.compose.internal.dnd.DragAndDropContext;
import com.teamdev.jxbrowser.view.compose.internal.dnd.MacOsCompatibility;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0016\u001a\u00020\u0015R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0017"}, d2={"Lcom/teamdev/jxbrowser/view/compose/internal/dnd/DragAndDropBridge;", "", "widget", "Lcom/teamdev/jxbrowser/browser/internal/BrowserWidget;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "externalDragEnabled", "", "<init>", "(Lcom/teamdev/jxbrowser/browser/internal/BrowserWidget;Lkotlinx/coroutines/CoroutineScope;Z)V", "context", "Lcom/teamdev/jxbrowser/view/compose/internal/dnd/DragAndDropContext;", "dragHandler", "Lcom/teamdev/jxbrowser/view/compose/internal/dnd/ChromiumDragHandler;", "getDragHandler", "()Lcom/teamdev/jxbrowser/view/compose/internal/dnd/ChromiumDragHandler;", "dropTarget", "Lcom/teamdev/jxbrowser/view/compose/internal/dnd/ChromiumDropTarget;", "getDropTarget", "()Lcom/teamdev/jxbrowser/view/compose/internal/dnd/ChromiumDropTarget;", "start", "", "stop", "compose"})
@StabilityInferred(parameters=0)
public final class DragAndDropBridge {
    @NotNull
    private final DragAndDropContext context;
    @NotNull
    private final ChromiumDragHandler dragHandler;
    @NotNull
    private final ChromiumDropTarget dropTarget;
    public static final int $stable = 8;

    public DragAndDropBridge(@NotNull BrowserWidget widget, @NotNull CoroutineScope scope, boolean externalDragEnabled) {
        Intrinsics.checkNotNullParameter((Object)widget, (String)"widget");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.context = new DragAndDropContext();
        this.dragHandler = new ChromiumDragHandler(widget, this.context, scope);
        this.dropTarget = new ChromiumDropTarget(widget, this.context, externalDragEnabled);
        if (Environment.isMac()) {
            MacOsCompatibility.INSTANCE.configureFlavorMap();
        }
        CustomDataSupport.INSTANCE.configureFlavorMap();
    }

    @NotNull
    public final ChromiumDragHandler getDragHandler() {
        return this.dragHandler;
    }

    @NotNull
    public final ChromiumDropTarget getDropTarget() {
        return this.dropTarget;
    }

    public final void start() {
        this.dragHandler.start();
        this.dropTarget.start();
    }

    public final void stop() {
        this.dropTarget.stop();
        this.dragHandler.stop();
    }
}

