/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.compose.internal.io;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.awt.AwtEvents_desktopKt;
import androidx.compose.ui.input.pointer.PointerEvent;
import androidx.compose.ui.input.pointer.PointerEventType;
import androidx.compose.ui.input.pointer.PointerInputChange;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.IntOffset;
import androidx.compose.ui.unit.IntOffsetKt;
import com.teamdev.jxbrowser.browser.internal.BrowserWidget;
import com.teamdev.jxbrowser.logging.Logger;
import com.teamdev.jxbrowser.os.Environment;
import com.teamdev.jxbrowser.ui.Point;
import com.teamdev.jxbrowser.ui.ScrollType;
import com.teamdev.jxbrowser.ui.event.MouseDragged;
import com.teamdev.jxbrowser.ui.event.MouseEntered;
import com.teamdev.jxbrowser.ui.event.MouseExited;
import com.teamdev.jxbrowser.ui.event.MouseMoved;
import com.teamdev.jxbrowser.ui.event.MousePressed;
import com.teamdev.jxbrowser.ui.event.MouseReleased;
import com.teamdev.jxbrowser.ui.event.MouseWheel;
import com.teamdev.jxbrowser.ui.internal.ScrollTypes;
import com.teamdev.jxbrowser.view.compose.internal.io.ImeEventHandler;
import com.teamdev.jxbrowser.view.compose.internal.io.Location;
import com.teamdev.jxbrowser.view.compose.internal.io.MouseEventDispatcherKt;
import com.teamdev.jxbrowser.view.compose.internal.io.ScrollData;
import com.teamdev.jxbrowser.view.compose.internal.render.ScalingKt;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.io.Serializable;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u0000 \u001b2\u00020\u0001:\u0002\u001a\u001bB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0013\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0014\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0015\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0016\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\n\u001a\u00020\u0019H\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/teamdev/jxbrowser/view/compose/internal/io/MouseEventDispatcher;", "", "widget", "Lcom/teamdev/jxbrowser/browser/internal/BrowserWidget;", "imeEventHandler", "Lcom/teamdev/jxbrowser/view/compose/internal/io/ImeEventHandler;", "<init>", "(Lcom/teamdev/jxbrowser/browser/internal/BrowserWidget;Lcom/teamdev/jxbrowser/view/compose/internal/io/ImeEventHandler;)V", "dispatch", "", "event", "Landroidx/compose/ui/input/pointer/PointerEvent;", "density", "Landroidx/compose/ui/unit/Density;", "mousePressed", "location", "Lcom/teamdev/jxbrowser/view/compose/internal/io/Location;", "mouseReleased", "mouseEntered", "mouseExited", "mouseMoved", "mouseDragged", "mouseScrolled", "calculateScrollData", "Lcom/teamdev/jxbrowser/view/compose/internal/io/ScrollData;", "Ljava/awt/event/MouseWheelEvent;", "PointsPerUnit", "Companion", "compose"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nMouseEventDispatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MouseEventDispatcher.kt\ncom/teamdev/jxbrowser/view/compose/internal/io/MouseEventDispatcher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,321:1\n1755#2,3:322\n*S KotlinDebug\n*F\n+ 1 MouseEventDispatcher.kt\ncom/teamdev/jxbrowser/view/compose/internal/io/MouseEventDispatcher\n*L\n124#1:322,3\n*E\n"})
public final class MouseEventDispatcher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BrowserWidget widget;
    @NotNull
    private final ImeEventHandler imeEventHandler;
    public static final int $stable = 8;
    private static final float POINTS_PER_UNIT;
    private static final int DIRECTION_FIX = -1;

    public MouseEventDispatcher(@NotNull BrowserWidget widget, @NotNull ImeEventHandler imeEventHandler) {
        Intrinsics.checkNotNullParameter((Object)widget, (String)"widget");
        Intrinsics.checkNotNullParameter((Object)imeEventHandler, (String)"imeEventHandler");
        this.widget = widget;
        this.imeEventHandler = imeEventHandler;
    }

    public final void dispatch(@NotNull PointerEvent event, @NotNull Density density) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        Location location = this.location(event, density);
        int n = event.getType-7fucELk();
        if (PointerEventType.equals-impl0((int)n, (int)PointerEventType.Companion.getPress-7fucELk())) {
            this.mousePressed(event, location);
        } else if (PointerEventType.equals-impl0((int)n, (int)PointerEventType.Companion.getRelease-7fucELk())) {
            this.mouseReleased(event, location);
        } else if (PointerEventType.equals-impl0((int)n, (int)PointerEventType.Companion.getEnter-7fucELk())) {
            this.mouseEntered(event, location);
        } else if (PointerEventType.equals-impl0((int)n, (int)PointerEventType.Companion.getExit-7fucELk())) {
            this.mouseExited(event, location);
        } else if (PointerEventType.equals-impl0((int)n, (int)PointerEventType.Companion.getScroll-7fucELk())) {
            this.mouseScrolled(event, location);
        } else if (PointerEventType.equals-impl0((int)n, (int)PointerEventType.Companion.getMove-7fucELk())) {
            boolean bl;
            block17: {
                Iterable $this$any$iv = event.getChanges();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        PointerInputChange it = (PointerInputChange)element$iv;
                        boolean bl2 = false;
                        if (!it.getPressed()) continue;
                        bl = true;
                        break block17;
                    }
                    bl = false;
                }
            }
            if (bl) {
                this.mouseDragged(event, location);
            } else {
                this.mouseMoved(event, location);
            }
        } else {
            Logger.debug((String)("Encountered an unexpected mouse event type: " + PointerEventType.toString-impl((int)event.getType-7fucELk())));
        }
    }

    private final void mousePressed(PointerEvent event, Location location) {
        this.imeEventHandler.cancelImeCompositionIfActive();
        this.widget.dispatch(MousePressed.newBuilder((Point)location.getLocalPoint()).locationOnScreen(location.getScreenPoint()).button(MouseEventDispatcherKt.access$getMouseButton(event)).clickCount(MouseEventDispatcherKt.access$getClickCount(event)).mouseModifiers(MouseEventDispatcherKt.access$getMouseModifiers(event)).keyModifiers(MouseEventDispatcherKt.access$getKeyModifiers(event)).build());
    }

    private final void mouseReleased(PointerEvent event, Location location) {
        this.widget.dispatch(MouseReleased.newBuilder((Point)location.getLocalPoint()).locationOnScreen(location.getScreenPoint()).button(MouseEventDispatcherKt.access$getMouseButton(event)).clickCount(MouseEventDispatcherKt.access$getClickCount(event)).mouseModifiers(MouseEventDispatcherKt.access$getMouseModifiers(event)).keyModifiers(MouseEventDispatcherKt.access$getKeyModifiers(event)).build());
    }

    private final void mouseEntered(PointerEvent event, Location location) {
        this.widget.dispatch(MouseEntered.newBuilder((Point)location.getLocalPoint()).locationOnScreen(location.getScreenPoint()).button(MouseEventDispatcherKt.access$getMouseButton(event)).mouseModifiers(MouseEventDispatcherKt.access$getMouseModifiers(event)).keyModifiers(MouseEventDispatcherKt.access$getKeyModifiers(event)).build());
    }

    private final void mouseExited(PointerEvent event, Location location) {
        this.widget.dispatch(MouseExited.newBuilder((Point)location.getLocalPoint()).locationOnScreen(location.getScreenPoint()).button(MouseEventDispatcherKt.access$getMouseButton(event)).mouseModifiers(MouseEventDispatcherKt.access$getMouseModifiers(event)).keyModifiers(MouseEventDispatcherKt.access$getKeyModifiers(event)).build());
    }

    private final void mouseMoved(PointerEvent event, Location location) {
        this.widget.dispatch(MouseMoved.newBuilder((Point)location.getLocalPoint()).locationOnScreen(location.getScreenPoint()).mouseModifiers(MouseEventDispatcherKt.access$getMouseModifiers(event)).keyModifiers(MouseEventDispatcherKt.access$getKeyModifiers(event)).build());
    }

    private final void mouseDragged(PointerEvent event, Location location) {
        this.widget.dispatch(MouseDragged.newBuilder((Point)location.getLocalPoint()).locationOnScreen(location.getScreenPoint()).button(MouseEventDispatcherKt.access$getMouseButton(event)).mouseModifiers(MouseEventDispatcherKt.access$getMouseModifiers(event)).keyModifiers(MouseEventDispatcherKt.access$getKeyModifiers(event)).build());
    }

    private final void mouseScrolled(PointerEvent event, Location location) {
        MouseEvent mouseEvent = AwtEvents_desktopKt.getAwtEventOrNull((PointerEvent)event);
        Intrinsics.checkNotNull((Object)mouseEvent, (String)"null cannot be cast to non-null type java.awt.event.MouseWheelEvent");
        MouseWheelEvent awtEvent = (MouseWheelEvent)mouseEvent;
        ScrollData scrollData = this.calculateScrollData(awtEvent);
        this.widget.dispatch(MouseWheel.newBuilder((Point)location.getLocalPoint()).locationOnScreen(location.getScreenPoint()).deltaX(scrollData.getDeltaX()).deltaY(scrollData.getDeltaY()).scrollType(scrollData.getScrollType()).keyModifiers(MouseEventDispatcherKt.access$getKeyModifiers(event)).build());
    }

    private final ScrollData calculateScrollData(MouseWheelEvent event) {
        ScrollType scrollType = ScrollTypes.forNumber((int)event.getScrollType());
        float delta = (float)event.getUnitsToScroll() * POINTS_PER_UNIT * (float)-1;
        float deltaX = event.isShiftDown() ? delta : 0.0f;
        float deltaY = !event.isShiftDown() ? delta : 0.0f;
        Intrinsics.checkNotNull((Object)scrollType);
        return new ScrollData(deltaX, deltaY, scrollType);
    }

    private final Location location(PointerEvent event, Density density) {
        long local = ScalingKt.scaled-ar5cAso(IntOffsetKt.round-k-4lQ0M((long)MouseEventDispatcherKt.getPosition(event)), density);
        Serializable serializable = AwtEvents_desktopKt.getAwtEventOrNull((PointerEvent)event);
        if (serializable == null || (serializable = serializable.getLocationOnScreen()) == null) {
            serializable = new java.awt.Point(IntOffset.getX-impl((long)local), IntOffset.getY-impl((long)local));
        }
        Serializable screen = serializable;
        Point point = Point.of((int)IntOffset.getX-impl((long)local), (int)IntOffset.getY-impl((long)local));
        Intrinsics.checkNotNullExpressionValue((Object)point, (String)"of(...)");
        Point point2 = Point.of((int)((java.awt.Point)screen).x, (int)((java.awt.Point)screen).y);
        Intrinsics.checkNotNullExpressionValue((Object)point2, (String)"of(...)");
        return new Location(point, point2);
    }

    static {
        PointsPerUnit $this$POINTS_PER_UNIT_u24lambda_u241 = PointsPerUnit.INSTANCE;
        boolean bl = false;
        POINTS_PER_UNIT = Environment.isMac() ? 10.0f : 33.333332f;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/teamdev/jxbrowser/view/compose/internal/io/MouseEventDispatcher$Companion;", "", "<init>", "()V", "POINTS_PER_UNIT", "", "DIRECTION_FIX", "", "compose"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/teamdev/jxbrowser/view/compose/internal/io/MouseEventDispatcher$PointsPerUnit;", "", "<init>", "()V", "MAC", "", "NON_MAC", "compose"})
    private static final class PointsPerUnit {
        @NotNull
        public static final PointsPerUnit INSTANCE = new PointsPerUnit();
        public static final float MAC = 10.0f;
        public static final float NON_MAC = 33.333332f;

        private PointsPerUnit() {
        }
    }
}

