/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.javafx.internal.dialog;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.view.javafx.internal.dialog.FxDialog;
import javafx.scene.control.TextField;
import javafx.scene.layout.Pane;
import javafx.stage.Window;

public final class PromptDialog
extends FxDialog<PromptDialog> {
    private final TextField textField;

    public static Builder newBuilder(Window owner, String message) {
        return new Builder(owner, message);
    }

    private PromptDialog(Builder builder) {
        super(builder);
        this.textField = new TextField(builder.initialText);
    }

    @Override
    protected void fillContentPanel(Pane contentPane) {
        contentPane.getChildren().add((Object)this.textField);
    }

    public String userInput() {
        return this.textField.getText();
    }

    protected PromptDialog self() {
        return this;
    }

    public static final class Builder
    extends FxDialog.FxDialogBuilder<PromptDialog, Builder> {
        private String initialText;

        private Builder(Window owner, String message) {
            super(owner, message);
        }

        public Builder initialText(String initialText) {
            this.initialText = (String)Preconditions.checkNotNull((Object)initialText);
            return this.self();
        }

        protected PromptDialog createDialog() {
            Preconditions.checkNotNull((Object)this.initialText, (Object)"The initial text is required for the prompt dialog.");
            return new PromptDialog(this);
        }

        protected Builder self() {
            return this;
        }
    }
}

