/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.javafx.internal.graphics;

import com.teamdev.jxbrowser.os.Environment;
import com.teamdev.jxbrowser.ui.Bitmap;
import com.teamdev.jxbrowser.ui.Size;
import com.teamdev.jxbrowser.view.graphics.BitmapImage;
import java.nio.ByteBuffer;
import javafx.scene.image.Image;
import javafx.scene.image.PixelFormat;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import javafx.scene.image.WritablePixelFormat;

public final class DragImage
extends BitmapImage<Image> {
    public static Image toToolkit(Bitmap bitmap) {
        return (Image)new DragImage(bitmap).toolkitImage();
    }

    private DragImage(Bitmap bitmap) {
        super(bitmap);
    }

    protected Image createImage() {
        Size size = this.bitmap().size();
        int width = size.width();
        int height = size.height();
        WritableImage image = new WritableImage(width, height);
        WritablePixelFormat<ByteBuffer> fmt = this.pixelFormat();
        PixelWriter writer = image.getPixelWriter();
        byte[] pixels = this.bitmap().pixels();
        writer.setPixels(0, 0, width, height, fmt, pixels, 0, width * 4);
        return image;
    }

    private WritablePixelFormat<ByteBuffer> pixelFormat() {
        return Environment.isMac() ? PixelFormat.getByteBgraInstance() : PixelFormat.getByteBgraPreInstance();
    }
}

