/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.javafx.internal.offscreen;

import com.teamdev.jxbrowser.browser.internal.WebDialog;
import com.teamdev.jxbrowser.browser.internal.callback.PaintWebDialogCallback;
import com.teamdev.jxbrowser.browser.internal.callback.WebDialogCallback;
import com.teamdev.jxbrowser.browser.internal.rpc.PaintDialog;
import com.teamdev.jxbrowser.browser.internal.rpc.PaintRequest;
import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.ui.Point;
import com.teamdev.jxbrowser.ui.Size;
import com.teamdev.jxbrowser.ui.internal.rpc.Rect;
import com.teamdev.jxbrowser.view.javafx.internal.offscreen.MemoryImage;
import javafx.application.Platform;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.Image;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.transform.Affine;

final class Graphics2dWebDialogView
extends StackPane
implements AutoCloseable {
    private static final int BORDER_WIDTH = 1;
    private final Canvas canvas;
    private final WebDialog webDialog;
    private final MemoryImage memoryImage;

    Graphics2dWebDialogView(WebDialog dialog) {
        Preconditions.checkNotNull((Object)dialog);
        this.webDialog = dialog;
        this.canvas = new Canvas();
        this.getChildren().add((Object)this.canvas);
        this.setBorder(new Border(new BorderStroke[]{new BorderStroke((Paint)Color.LIGHTGRAY, BorderStrokeStyle.SOLID, CornerRadii.EMPTY, BorderWidths.DEFAULT)}));
        this.memoryImage = new MemoryImage();
        dialog.set(PaintWebDialogCallback.class, (WebDialogCallback)((PaintWebDialogCallback)params -> {
            MemoryImage memoryImage = this.memoryImage;
            synchronized (memoryImage) {
                PaintRequest request = params.getPaintRequest();
                com.teamdev.jxbrowser.ui.internal.rpc.Size viewSize = request.getViewSize();
                Rect dirtyRect = request.getDirtyRect();
                if (!Graphics2dWebDialogView.validateDirtyRect((com.teamdev.jxbrowser.ui.Rect)dirtyRect, (Size)viewSize)) {
                    return PaintDialog.Response.newBuilder().build();
                }
                this.memoryImage.updateImage((Size)viewSize, (com.teamdev.jxbrowser.ui.Rect)dirtyRect, request.getMemoryId(), request.getScaleFactor());
            }
            Platform.runLater(this::paint);
            return PaintDialog.Response.newBuilder().build();
        }));
    }

    public void setSize(Size sizeInPoints) {
        int width = sizeInPoints.width();
        int height = sizeInPoints.height();
        this.setMaxWidth(width + 2);
        this.setMaxHeight(height + 2);
        this.setMinWidth(width + 2);
        this.setMinHeight(height + 2);
        this.canvas.setWidth((double)width);
        this.canvas.setHeight((double)height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paint() {
        GraphicsContext graphics2d = this.canvas.getGraphicsContext2D();
        MemoryImage memoryImage = this.memoryImage;
        synchronized (memoryImage) {
            double deviceScaleFactor = this.memoryImage.getDeviceScaleFactor();
            double scale = 1.0 / deviceScaleFactor;
            Affine transform = graphics2d.getTransform();
            transform.setMxx(scale);
            transform.setMyy(scale);
            graphics2d.setTransform(transform);
            this.memoryImage.image().ifPresent(image -> {
                graphics2d.clearRect(0.0, 0.0, image.getWidth(), image.getHeight());
                graphics2d.drawImage((Image)image, 0.0, 0.0, image.getWidth(), image.getHeight());
            });
        }
    }

    private static boolean validateDirtyRect(com.teamdev.jxbrowser.ui.Rect dirtyRect, Size viewSize) {
        int viewWidth = viewSize.width();
        int viewHeight = viewSize.height();
        Point dirtyRectOrigin = dirtyRect.origin();
        Size dirtyRectSize = dirtyRect.size();
        return dirtyRectOrigin.x() <= viewWidth && dirtyRectOrigin.y() <= viewHeight && dirtyRectOrigin.x() + dirtyRectSize.width() <= viewWidth && dirtyRectOrigin.y() + dirtyRectSize.height() <= viewHeight;
    }

    @Override
    public void close() {
        this.webDialog.remove(PaintWebDialogCallback.class);
    }
}

