/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.javafx.internal.offscreen;

import com.teamdev.jxbrowser.browser.internal.BrowserWidget;
import com.teamdev.jxbrowser.browser.internal.WebDialog;
import com.teamdev.jxbrowser.browser.internal.callback.BrowserWidgetCallback;
import com.teamdev.jxbrowser.browser.internal.callback.CreateWebDialogCallback;
import com.teamdev.jxbrowser.browser.internal.callback.UpdateLayerCallback;
import com.teamdev.jxbrowser.browser.internal.callback.UpdateSurfaceCallback;
import com.teamdev.jxbrowser.browser.internal.rpc.CreateWebDialog;
import com.teamdev.jxbrowser.browser.internal.rpc.UpdateLayer;
import com.teamdev.jxbrowser.browser.internal.rpc.UpdateSurface;
import com.teamdev.jxbrowser.ui.Point;
import com.teamdev.jxbrowser.ui.Rect;
import com.teamdev.jxbrowser.view.internal.mac.NsView;
import com.teamdev.jxbrowser.view.javafx.BrowserView;
import com.teamdev.jxbrowser.view.javafx.internal.offscreen.ContentNode;
import com.teamdev.jxbrowser.view.javafx.internal.offscreen.IoSurfaceWebDialogView;
import com.teamdev.jxbrowser.view.javafx.internal.offscreen.OffScreenRenderWidget;
import com.teamdev.jxbrowser.view.javafx.internal.window.FxPanel;
import com.teamdev.jxbrowser.view.javafx.internal.window.NativeAwareWindow;
import java.util.Optional;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.layout.StackPane;
import javafx.stage.Window;

public final class IoSurfaceRenderWidget
extends OffScreenRenderWidget<StackPane> {
    private final NsView nsView;

    public IoSurfaceRenderWidget(BrowserWidget widget, BrowserView browserView) {
        super(widget, browserView, new ContentPane());
        this.nsView = new NsView(widget);
        widget.set(CreateWebDialogCallback.class, (BrowserWidgetCallback)((CreateWebDialogCallback)params -> {
            WebDialog webDialog = new WebDialog(widget.browser(), params.getWebDialogId());
            IoSurfaceWebDialogView webDialogView = new IoSurfaceWebDialogView(widget, (Node)browserView, webDialog);
            Platform.runLater(() -> {
                NativeAwareWindow window = this.window();
                if (window != null) {
                    long nsViewId = window.nativeId();
                    webDialogView.show(nsViewId, (Rect)params.getInitialBounds());
                }
            });
            return CreateWebDialog.Response.newBuilder().build();
        }));
        widget.set(UpdateSurfaceCallback.class, (BrowserWidgetCallback)((UpdateSurfaceCallback)params -> {
            this.nsView.updateSurface(params.getSurfaceId(), params.getScaleFactor());
            return UpdateSurface.Response.newBuilder().build();
        }));
        widget.set(UpdateLayerCallback.class, (BrowserWidgetCallback)((UpdateLayerCallback)params -> {
            this.nsView.setNsViewLayer(params.getContextId(), params.getScaleFactor());
            return UpdateLayer.Response.newBuilder().build();
        }));
    }

    @Override
    protected void close() {
        this.widget.remove(CreateWebDialogCallback.class);
        this.nsView.close();
        super.close();
    }

    @Override
    protected void show() {
        if (this.isWidgetShown()) {
            return;
        }
        super.show();
        NativeAwareWindow window = this.window();
        if (window != null) {
            Rectangle2D bounds = this.getBounds();
            Rect rect = Rect.of((int)((int)bounds.getMinX()), (int)((int)bounds.getMinY()), (int)((int)bounds.getWidth()), (int)((int)bounds.getHeight()));
            this.nsView.show(window.nativeId(), rect);
        }
        this.widget.attach(0L);
    }

    @Override
    public void hide() {
        if (!this.isWidgetShown()) {
            return;
        }
        this.nsView.hide();
        super.hide();
    }

    @Override
    protected boolean trackSizeWhenHidden() {
        return true;
    }

    @Override
    public void updateBounds() {
        super.updateBounds();
        Rectangle2D bounds = this.getBounds();
        this.nsView.updateBounds(Rect.of((int)((int)bounds.getMinX()), (int)((int)bounds.getMinY()), (int)((int)bounds.getWidth()), (int)((int)bounds.getHeight())));
    }

    private Rectangle2D getBounds() {
        Scene scene = this.getScene();
        if (scene != null) {
            Window window = scene.getWindow();
            Optional node = this.node();
            if (window != null && node.isPresent()) {
                StackPane pane = (StackPane)node.get();
                Point2D widgetLocation = pane.localToScreen(0.0, 0.0);
                double sceneX = scene.getX();
                double sceneY = scene.getY();
                double windowX = window.getX();
                double windowY = window.getY();
                Point inWindow = Point.of((int)((int)Math.round(widgetLocation.getX() - windowX - sceneX)), (int)((int)Math.round(widgetLocation.getY() - windowY - sceneY)));
                inWindow = FxPanel.inWindowPoint(window, pane.getHeight(), inWindow);
                return new Rectangle2D((double)inWindow.x(), (double)inWindow.y(), pane.getWidth(), pane.getHeight());
            }
        }
        return new Rectangle2D(0.0, 0.0, 0.0, 0.0);
    }

    private Scene getScene() {
        return this.node().map(Node::getScene).orElse(null);
    }

    private static final class ContentPane
    extends ContentNode<StackPane> {
        ContentPane() {
            super(new StackPane());
        }

        @Override
        public ReadOnlyDoubleProperty heightProperty() {
            return ((StackPane)this.toolkitNode()).heightProperty();
        }

        @Override
        public ReadOnlyDoubleProperty widthProperty() {
            return ((StackPane)this.toolkitNode()).widthProperty();
        }

        @Override
        public double getHeight() {
            return ((StackPane)this.toolkitNode()).getHeight();
        }

        @Override
        public double getWidth() {
            return ((StackPane)this.toolkitNode()).getWidth();
        }
    }
}

