/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.javafx.internal.offscreen;

import com.teamdev.jxbrowser.browser.internal.BrowserWidget;
import com.teamdev.jxbrowser.browser.internal.rpc.TooltipChanged;
import com.teamdev.jxbrowser.event.Observer;
import com.teamdev.jxbrowser.event.Subscription;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.control.Tooltip;

final class TooltipListener
implements Observer<TooltipChanged> {
    private final Tooltip tooltip;
    private final BrowserWidget browserWidget;
    private Node node;
    private Subscription subscription;

    TooltipListener(BrowserWidget widget) {
        this.browserWidget = widget;
        this.tooltip = new Tooltip();
    }

    public void on(TooltipChanged event) {
        Platform.runLater(() -> {
            if (this.node != null) {
                String text = event.getTooltipText();
                if (!text.isEmpty()) {
                    this.tooltip.setText(text);
                    Tooltip.install((Node)this.node, (Tooltip)this.tooltip);
                } else {
                    Tooltip.uninstall((Node)this.node, (Tooltip)this.tooltip);
                }
            }
        });
    }

    void attach(Node node) {
        this.node = node;
        this.subscription = this.browserWidget.on(TooltipChanged.class, (Observer)this);
    }

    void detach() {
        if (this.subscription != null) {
            this.subscription.unsubscribe();
        }
        this.node = null;
    }
}

