#  Copyright (c) 2000-2026 TeamDev. All rights reserved.
#  TeamDev PROPRIETARY and CONFIDENTIAL.
#  Use is subject to license terms.

from common import get_project_root
from common import get_chromium_src_dir
import shutil
import os


def get_original_icon_path(icon_name):
    original_icons_relpath = ["chrome", "app", "theme", "chromium", "win"]
    return os.path.join(get_chromium_src_dir(), *original_icons_relpath, icon_name)


def try_replace(original_icon_name):
    source = os.path.join(get_project_root(), "resources", "chromium.ico")
    destination = get_original_icon_path(original_icon_name)

    if not os.path.exists(destination):
        raise Exception("Cannot replace " + original_icon_name
                        + ": file is probably moved or deleted in this Chromium revision.")
    shutil.copyfile(source, destination)


def update_icon():
    """
    Updates the default Chromium icons with our custom ones.
    """
    print("Updating Chromium icon...")
    try_replace("chromium.ico")
    print("Chromium icon has been updated successfully.")


def main():
    update_icon()


if __name__ == "__main__":
    main()
