// Copyright (c) 2000-2026 TeamDev. All rights reserved.
// TeamDev PROPRIETARY and CONFIDENTIAL.
// Use is subject to license terms.

#ifndef INCLUDE_PLATINUM_BROWSER_FACTORY_H_
#define INCLUDE_PLATINUM_BROWSER_FACTORY_H_

#include "base/memory/weak_ptr.h"
#include "base/time/time.h"

namespace extensions {
class MimeHandlerViewGuest;
class MimeHandlerViewGuestDelegate;
class ChromeExtensionsBrowserClient;
}  // namespace extensions

namespace network {
namespace mojom {
class NetworkContext;
}  // namespace mojom

class NetworkService;
class NetworkContext;
}  // namespace network

namespace autofill {
class AutofillClient;
class PersonalDataManager;
class AddressProfileSaveManager;
class CreditCardSaveManager;
namespace payments {
class PaymentsNetworkInterface;
}
}  // namespace autofill

class Browser;
class BrowserWindowInterface;
class Profile;
class ProfileManager;
class OffTheRecordProfileImpl;
class SpellcheckService;

class ChromeDownloadManagerDelegate;
class TabStripModelDelegate;

namespace chrome {
class BrowserCommandController;
}  // namespace chrome

namespace base {
class FilePath;
class SequencedTaskRunner;
}  // namespace base

namespace content {
class WebContentsImpl;
class WebContentsViewDelegate;
class WebContentsViewMac;
class WebContents;
class BrowserContext;
class RenderFrameHost;
struct GlobalRenderFrameHostId;
#if BUILDFLAG(IS_WIN)
class WebAXPlatformTreeManagerDelegate;
class BrowserFrameViewWin;
#endif
}  // namespace content

class ChromePluginServiceFilter;
class Profile;

namespace printing {
class PrinterHandler;
class PrintPreviewStickySettings;
class PrintingContext;
}  // namespace printing

namespace media_router {
class MediaRouterDialogController;
}

namespace permissions {
class PermissionManager;
}  // namespace permissions

namespace net {
class URLRequestJobFactory;
class CertVerifier;
}  // namespace net

#if BUILDFLAG(IS_WIN)
namespace ui {
class BrowserAccessibilityManagerWin;
}
#endif

#if BUILDFLAG(IS_MAC)
namespace ui {
class BrowserAccessibilityManager;
}
#endif

#if BUILDFLAG(IS_WIN) || BUILDFLAG(IS_MAC)
namespace ui {
struct AXTreeUpdate;
class AXPlatformTreeManagerDelegate;
class AXNodeIdDelegate;
}  // namespace ui
#endif

#if BUILDFLAG(IS_LINUX)
namespace aura {
class InputStateLookup;
}
#endif

#if BUILDFLAG(IS_WIN)
namespace ui {
class VirtualKeyboardController;
}
class BrowserCaptionButtonContainer;
class BrowserFrameViewWin;
#endif

class BrowserView;
class OpaqueBrowserFrameViewLayout;
class OpaqueBrowserFrameView;
class BrowserWidget;

class PlatinumFactory {
 public:
  template <class CreateParams>
  static Browser* CreateBrowser(const CreateParams& params);

  template <class T>
  static std::unique_ptr<T> CreateWebContentsView(
      content::WebContentsImpl* web_contents,
      std::unique_ptr<content::WebContentsViewDelegate> delegate);

  template <typename TDelegate, typename TCreateMode>
  static Profile* CreateProfile(const base::FilePath& path,
                                TDelegate* delegate,
                                TCreateMode create_mode,
                                base::Time creation_time,
                                scoped_refptr<base::SequencedTaskRunner> io_task_runner);

  static std::unique_ptr<ProfileManager> CreateProfileManager(const base::FilePath& user_data_dir);

  template <class OTRProfileID>
  static std::unique_ptr<OffTheRecordProfileImpl> CreateOffTheRecordProfile(
      ::Profile* original,
      const OTRProfileID& otr_profile_id);

  static ChromeDownloadManagerDelegate* CreateDownloadManagerDelegate(Profile* profile);

  static void CreateMediaRouterDialogController(content::WebContents* webContents);

  static media_router::MediaRouterDialogController* GetMediaRouterDialogController(
      content::WebContents* webContents);

  static std::unique_ptr<TabStripModelDelegate> CreateTabStripModelDelegate(Browser* browser);
  static std::unique_ptr<chrome::BrowserCommandController> CreateBrowserCommandController(
      BrowserWindowInterface* browser);

  static std::unique_ptr<printing::PrinterHandler> CreatePdfPrinterHandler(
      Profile* profile,
      content::WebContents* preview_web_contents,
      printing::PrintPreviewStickySettings* sticky_settings);

#if BUILDFLAG(IS_WIN)
  template <class Delegate, class Behavior>
  static std::unique_ptr<printing::PrintingContext> CreatePrintingContextSystemDialogWin(
      content::GlobalRenderFrameHostId rfh_id,
      Delegate* delegate,
      Behavior behavior);
  static ui::BrowserAccessibilityManagerWin* CreateBrowserAccessibilityManagerWin(
      const ui::AXTreeUpdate& initial_tree,
      ui::AXNodeIdDelegate* node_id_delegate,
      ui::AXPlatformTreeManagerDelegate* delegate);
  static std::unique_ptr<BrowserCaptionButtonContainer> CreateBrowserCaptionButtonContainer(
      BrowserFrameViewWin* frame_view);
  static std::unique_ptr<BrowserFrameViewWin> CreateBrowserFrameViewWin(
      BrowserWidget* browser_widget,
      BrowserView* browser_view);
#endif

#if BUILDFLAG(IS_MAC)
  static ui::BrowserAccessibilityManager* CreateBrowserAccessibilityManagerMac(
      const ui::AXTreeUpdate& initial_tree,
      ui::AXNodeIdDelegate* node_id_delegate,
      ui::AXPlatformTreeManagerDelegate* delegate);
#endif

  static std::unique_ptr<OpaqueBrowserFrameView> CreateOpaqueBrowserFrameView(
      BrowserWidget* browser_widget,
      BrowserView* browser_view,
      OpaqueBrowserFrameViewLayout* layout);

  static ChromePluginServiceFilter* CreatePluginServiceFilterSingleton();

  template <class PermissionContextMap>
  static std::unique_ptr<permissions::PermissionManager> CreatePermissionManager(
      content::BrowserContext* context,
      PermissionContextMap&& permission_contexts);

  static std::unique_ptr<autofill::AddressProfileSaveManager> CreateAddressProfileManager(
      autofill::AutofillClient* client);

  static std::unique_ptr<autofill::CreditCardSaveManager> CreateCreditCardManager(
      autofill::AutofillClient* client);

  static std::unique_ptr<SpellcheckService> CreateSpellcheckService(
      content::BrowserContext* context);

  static std::unique_ptr<extensions::MimeHandlerViewGuestDelegate>
  CreateMimeHandlerViewGuestDelegate();

  static extensions::MimeHandlerViewGuest* CreateMimeHandlerViewGuest(
      content::RenderFrameHost* owner_rfh);

  static std::unique_ptr<extensions::ChromeExtensionsBrowserClient> CreateExtensionBrowserClient();

#if BUILDFLAG(IS_LINUX)
  static std::unique_ptr<aura::InputStateLookup> CreateInputStateLookup();
#endif

#if BUILDFLAG(IS_WIN)
  static std::unique_ptr<ui::VirtualKeyboardController> CreateKeyboardController(
      HWND attached_window_handle);
#endif
};

#endif  // INCLUDE_PLATINUM_BROWSER_FACTORY_H_
