// Copyright (c) 2000-2026 TeamDev. All rights reserved.
// TeamDev PROPRIETARY and CONFIDENTIAL.
// Use is subject to license terms.

#ifndef CORE_MAIN_BROWSER_CAPTURE_CAPTURE_HIDDEN_NOTIFICATION_UI_H_
#define CORE_MAIN_BROWSER_CAPTURE_CAPTURE_HIDDEN_NOTIFICATION_UI_H_

#include "chrome/browser/media/webrtc/media_stream_capture_indicator.h"
#include "content/public/browser/web_contents.h"
#include "content/public/browser/web_contents_delegate.h"

namespace platinum {

// A non-visual MediaStreamUI implementation used when the capture notification UI
// is intentionally hidden. This class ensures that capture session lifecycle
// management (e.g., stopping capture) continues to work correctly even without UI.
class CaptureHiddenNotificationUI : public MediaStreamUI {
 public:
  explicit CaptureHiddenNotificationUI(content::WebContents* web_contents);
  ~CaptureHiddenNotificationUI() override;

  // Factory method for creating an instance.
  static std::unique_ptr<MediaStreamUI> Create(content::WebContents* web_contents);

  // Called when the media capture session starts.
  // Stores the stop callback for later invocation.
  gfx::NativeViewId OnStarted(base::OnceClosure stop_callback,
                              content::MediaStreamUI::SourceCallback source_callback,
                              const std::vector<content::DesktopMediaID>& media_ids,
                              content::WebContents* initiator_contents) override;

  // This overload is intentionally left unimplemented.
  // Due to our patch set, only the version of the method with the "initiator_contents"
  // parameter is ever used. The original overload is never called anywhere, so providing
  // an implementation is unnecessary. So we just return 0 in this case.
  gfx::NativeViewId OnStarted(base::OnceClosure stop_callback,
                              content::MediaStreamUI::SourceCallback source_callback,
                              const std::vector<content::DesktopMediaID>& media_ids) override;

  // Called to programmatically stop the media capture session.
  void RequestStop() override;

 private:
  base::raw_ptr<content::WebContents> web_contents_;
  base::OnceClosure stop_callback_;
  base::WeakPtrFactory<CaptureHiddenNotificationUI> weak_factory_{this};
};

}  // namespace platinum

#endif  // CORE_MAIN_BROWSER_CAPTURE_CAPTURE_HIDDEN_NOTIFICATION_UI_H_
