/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.compose.internal;

import androidx.compose.runtime.MutableState;
import androidx.compose.runtime.SnapshotStateKt;
import androidx.compose.runtime.Stable;
import androidx.compose.ui.layout.LayoutCoordinates;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.IntOffset;
import androidx.compose.ui.unit.IntSize;
import com.teamdev.jxbrowser.browser.internal.BrowserWidget;
import com.teamdev.jxbrowser.browser.internal.WebDialog;
import com.teamdev.jxbrowser.browser.internal.callback.CreateWebDialogCallback;
import com.teamdev.jxbrowser.browser.internal.callback.UpdateLayerCallback;
import com.teamdev.jxbrowser.browser.internal.callback.UpdateSurfaceCallback;
import com.teamdev.jxbrowser.browser.internal.rpc.CreateWebDialog;
import com.teamdev.jxbrowser.browser.internal.rpc.UpdateLayer;
import com.teamdev.jxbrowser.browser.internal.rpc.UpdateSurface;
import com.teamdev.jxbrowser.callback.Advisable;
import com.teamdev.jxbrowser.callback.Callback;
import com.teamdev.jxbrowser.dsl.ui.RectKt;
import com.teamdev.jxbrowser.ui.internal.rpc.Rect;
import com.teamdev.jxbrowser.view.compose.internal.OffScreenWidgetState;
import com.teamdev.jxbrowser.view.compose.internal.components.dialogs.SharedSurfaceWebDialog;
import com.teamdev.jxbrowser.view.compose.internal.render.AwtWindowKt;
import com.teamdev.jxbrowser.view.compose.internal.render.ScalingKt;
import com.teamdev.jxbrowser.view.internal.mac.NsView;
import java.awt.Window;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0011H\u0016J\u0018\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\f\u0010\u0018\u001a\u00020\u000e*\u00020\u000eH\u0002J\b\u0010\u0019\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\f\u001a\u0010\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000e0\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/teamdev/jxbrowser/view/compose/internal/SharedSurfaceWidget;", "Lcom/teamdev/jxbrowser/view/compose/internal/OffScreenWidgetState;", "widget", "Lcom/teamdev/jxbrowser/browser/internal/BrowserWidget;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "window", "Ljava/awt/Window;", "<init>", "(Lcom/teamdev/jxbrowser/browser/internal/BrowserWidget;Lkotlinx/coroutines/CoroutineScope;Ljava/awt/Window;)V", "nsView", "Lcom/teamdev/jxbrowser/view/internal/mac/NsView;", "bounds", "Landroidx/compose/runtime/MutableState;", "Lcom/teamdev/jxbrowser/ui/Rect;", "kotlin.jvm.PlatformType", "show", "", "hide", "onPositioned", "coords", "Landroidx/compose/ui/layout/LayoutCoordinates;", "density", "Landroidx/compose/ui/unit/Density;", "withInvertedY", "close", "compose"})
@Stable
@SourceDebugExtension(value={"SMAP\nSharedSurfaceWidget.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SharedSurfaceWidget.kt\ncom/teamdev/jxbrowser/view/compose/internal/SharedSurfaceWidget\n+ 2 Async.kt\ncom/teamdev/jxbrowser/dsl/AsyncKt\n*L\n1#1,132:1\n44#2:133\n44#2:134\n44#2:135\n61#2:136\n61#2:137\n61#2:138\n*S KotlinDebug\n*F\n+ 1 SharedSurfaceWidget.kt\ncom/teamdev/jxbrowser/view/compose/internal/SharedSurfaceWidget\n*L\n63#1:133\n75#1:134\n79#1:135\n124#1:136\n125#1:137\n126#1:138\n*E\n"})
public final class SharedSurfaceWidget
extends OffScreenWidgetState {
    @NotNull
    private final BrowserWidget widget;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final Window window;
    @NotNull
    private final NsView nsView;
    @NotNull
    private final MutableState<com.teamdev.jxbrowser.ui.Rect> bounds;
    public static final int $stable;

    public SharedSurfaceWidget(@NotNull BrowserWidget widget, @NotNull CoroutineScope scope, @NotNull Window window) {
        Advisable $this$register$iv;
        BrowserWidget browserWidget;
        Intrinsics.checkNotNullParameter((Object)widget, (String)"widget");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        super(widget, scope, window);
        this.widget = widget;
        this.scope = scope;
        this.window = window;
        this.nsView = new NsView(this.widget);
        this.bounds = SnapshotStateKt.mutableStateOf$default((Object)com.teamdev.jxbrowser.ui.Rect.empty(), null, (int)2, null);
        BrowserWidget $this$_init__u24lambda_u243 = browserWidget = this.widget;
        boolean bl = false;
        Advisable advisable = (Advisable)$this$_init__u24lambda_u243;
        Callback callback$iv = (Callback)((CreateWebDialogCallback)arg_0 -> SharedSurfaceWidget.lambda$3$lambda$0(this, arg_0));
        boolean $i$f$register = false;
        $this$register$iv.set(CreateWebDialogCallback.class, callback$iv);
        $this$register$iv = (Advisable)$this$_init__u24lambda_u243;
        callback$iv = (Callback)((UpdateSurfaceCallback)arg_0 -> SharedSurfaceWidget.lambda$3$lambda$1(this, arg_0));
        $i$f$register = false;
        $this$register$iv.set(UpdateSurfaceCallback.class, callback$iv);
        $this$register$iv = (Advisable)$this$_init__u24lambda_u243;
        callback$iv = (Callback)((UpdateLayerCallback)arg_0 -> SharedSurfaceWidget.lambda$3$lambda$2(this, arg_0));
        $i$f$register = false;
        $this$register$iv.set(UpdateLayerCallback.class, callback$iv);
    }

    @Override
    public void show() {
        if (this.isShown()) {
            return;
        }
        Long l = AwtWindowKt.getNativeId(this.window);
        if (l == null) {
            return;
        }
        long windowId = l;
        Object object = this.bounds.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-value>(...)");
        this.nsView.show(windowId, this.withInvertedY((com.teamdev.jxbrowser.ui.Rect)object));
        super.show();
    }

    @Override
    public void hide() {
        if (!this.isShown()) {
            return;
        }
        super.hide();
        this.nsView.hide();
    }

    @Override
    public void onPositioned(@NotNull LayoutCoordinates coords, @NotNull Density density) {
        Intrinsics.checkNotNullParameter((Object)coords, (String)"coords");
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        super.onPositioned(coords, density);
        long size = ScalingKt.scaledSize(coords, density);
        if (IntSize.getWidth-impl((long)size) >= 0 && IntSize.getHeight-impl((long)size) >= 0) {
            long position = ScalingKt.scaledPositionInRoot(coords, density);
            this.bounds.setValue((Object)RectKt.Rect((int)IntOffset.getX-impl((long)position), (int)IntOffset.getY-impl((long)position), (int)IntSize.getWidth-impl((long)size), (int)IntSize.getHeight-impl((long)size)));
            Object object = this.bounds.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-value>(...)");
            this.nsView.updateBounds(this.withInvertedY((com.teamdev.jxbrowser.ui.Rect)object));
        }
    }

    private final com.teamdev.jxbrowser.ui.Rect withInvertedY(com.teamdev.jxbrowser.ui.Rect $this$withInvertedY) {
        return RectKt.Rect((int)$this$withInvertedY.x(), (int)(this.window.getHeight() - this.window.getInsets().top - $this$withInvertedY.height() - $this$withInvertedY.y()), (int)$this$withInvertedY.width(), (int)$this$withInvertedY.height());
    }

    @Override
    public void close() {
        BrowserWidget browserWidget;
        BrowserWidget $this$close_u24lambda_u244 = browserWidget = this.widget;
        boolean bl = false;
        Advisable $this$removeCallback$iv = (Advisable)$this$close_u24lambda_u244;
        boolean $i$f$removeCallback = false;
        $this$removeCallback$iv.remove(UpdateLayerCallback.class);
        $this$removeCallback$iv = (Advisable)$this$close_u24lambda_u244;
        $i$f$removeCallback = false;
        $this$removeCallback$iv.remove(UpdateSurfaceCallback.class);
        $this$removeCallback$iv = (Advisable)$this$close_u24lambda_u244;
        $i$f$removeCallback = false;
        $this$removeCallback$iv.remove(CreateWebDialogCallback.class);
        this.nsView.close();
        super.close();
    }

    private static final CreateWebDialog.Response lambda$3$lambda$0(SharedSurfaceWidget this$0, CreateWebDialog.Request params) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        SharedSurfaceWebDialog dialog = new SharedSurfaceWebDialog(new WebDialog(this$0.widget.browser(), params.getWebDialogId()), this$0.bounds, this$0.window, this$0.scope);
        BuildersKt.launch$default((CoroutineScope)this$0.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(dialog, params, null){
            int label;
            final /* synthetic */ SharedSurfaceWebDialog $dialog;
            final /* synthetic */ CreateWebDialog.Request $params;
            {
                this.$dialog = $dialog;
                this.$params = $params;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Rect rect = this.$params.getInitialBounds();
                        Intrinsics.checkNotNullExpressionValue((Object)rect, (String)"getInitialBounds(...)");
                        this.$dialog.show((com.teamdev.jxbrowser.ui.Rect)rect);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        return CreateWebDialog.Response.newBuilder().build();
    }

    private static final UpdateSurface.Response lambda$3$lambda$1(SharedSurfaceWidget this$0, UpdateSurface.Request it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.nsView.updateSurface(it.getSurfaceId(), it.getScaleFactor());
        return UpdateSurface.Response.newBuilder().build();
    }

    private static final UpdateLayer.Response lambda$3$lambda$2(SharedSurfaceWidget this$0, UpdateLayer.Request it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.nsView.setNsViewLayer(it.getContextId(), it.getScaleFactor());
        return UpdateLayer.Response.newBuilder().build();
    }
}

