/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.compose.internal.dnd;

import androidx.compose.runtime.internal.StabilityInferred;
import com.teamdev.jxbrowser.logging.Logger;
import com.teamdev.jxbrowser.view.compose.internal.dnd.CustomDataSupport;
import com.teamdev.jxbrowser.view.compose.internal.dnd.MimeType;
import com.teamdev.jxbrowser.view.compose.internal.dnd.RichDataFlavor;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u0012*\u00020\f2\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0014H\u0002J\u0014\u0010\u0015\u001a\u0004\u0018\u00010\u0012*\b\u0012\u0004\u0012\u00020\u00120\u0016H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/teamdev/jxbrowser/view/compose/internal/dnd/StringDataFlavor;", "Lcom/teamdev/jxbrowser/view/compose/internal/dnd/RichDataFlavor;", "", "mimeType", "Lcom/teamdev/jxbrowser/view/compose/internal/dnd/MimeType;", "charset", "Ljava/nio/charset/Charset;", "<init>", "(Lcom/teamdev/jxbrowser/view/compose/internal/dnd/MimeType;Ljava/nio/charset/Charset;)V", "isPresentedIn", "", "transferable", "Ljava/awt/datatransfer/Transferable;", "read", "readAsString", "readAsByteArray", "readUsingFlavors", "dataFlavorForType", "Ljava/awt/datatransfer/DataFlavor;", "representationClass", "Ljava/lang/Class;", "findForCharset", "", "compose"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nStringDataFlavor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StringDataFlavor.kt\ncom/teamdev/jxbrowser/view/compose/internal/dnd/StringDataFlavor\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,88:1\n3829#2:89\n4344#2,2:90\n3829#2:95\n4344#2,2:96\n1755#3,3:92\n774#3:98\n865#3,2:99\n827#3:101\n855#3,2:102\n295#3,2:104\n*S KotlinDebug\n*F\n+ 1 StringDataFlavor.kt\ncom/teamdev/jxbrowser/view/compose/internal/dnd/StringDataFlavor\n*L\n27#1:89\n27#1:90,2\n75#1:95\n75#1:96,2\n28#1:92,3\n76#1:98\n76#1:99,2\n77#1:101\n77#1:102,2\n83#1:104,2\n*E\n"})
public final class StringDataFlavor
extends RichDataFlavor<String> {
    @NotNull
    private final Charset charset;
    public static final int $stable = 8;

    public StringDataFlavor(@NotNull MimeType mimeType, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        super(mimeType);
        this.charset = charset;
    }

    public /* synthetic */ StringDataFlavor(MimeType mimeType, Charset charset, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            charset = StandardCharsets.UTF_8;
        }
        this(mimeType, charset);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isPresentedIn(@NotNull Transferable transferable) {
        boolean bl;
        block4: {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Intrinsics.checkNotNullParameter((Object)transferable, (String)"transferable");
            DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
            Intrinsics.checkNotNullExpressionValue((Object)dataFlavorArray, (String)"getTransferDataFlavors(...)");
            Object[] objectArray = dataFlavorArray;
            MimeType mimeType = this.getMimeType();
            boolean $i$f$filter = false;
            void var5_7 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (void element$iv$iv : $this$filterTo$iv$iv) {
                DataFlavor p0 = (DataFlavor)element$iv$iv;
                boolean bl2 = false;
                if (!mimeType.matches(p0)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$any$iv = (List)destination$iv$iv;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    DataFlavor it = (DataFlavor)element$iv;
                    boolean bl3 = false;
                    Intrinsics.checkNotNull((Object)it);
                    if (!(!CustomDataSupport.INSTANCE.isCustomDataFlavor(it))) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    @NotNull
    public String read(@NotNull Transferable transferable) {
        Intrinsics.checkNotNullParameter((Object)transferable, (String)"transferable");
        String string = this.readAsString(transferable);
        if (string == null && (string = this.readAsByteArray(transferable)) == null && (string = this.readUsingFlavors(transferable)) == null) {
            throw this.noSuitableFlavor();
        }
        return string;
    }

    private final String readAsString(Transferable transferable) {
        String string;
        DataFlavor stringFlavor;
        DataFlavor dataFlavor = stringFlavor = this.dataFlavorForType(transferable, String.class);
        if (dataFlavor != null) {
            DataFlavor it = dataFlavor;
            boolean bl = false;
            Object object = transferable.getTransferData(it);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
            string = (String)object;
        } else {
            string = null;
        }
        return string;
    }

    private final String readAsByteArray(Transferable transferable) {
        String string;
        DataFlavor byteArrayFlavor;
        DataFlavor dataFlavor = byteArrayFlavor = this.dataFlavorForType(transferable, byte[].class);
        if (dataFlavor != null) {
            DataFlavor it = dataFlavor;
            boolean bl = false;
            Object object = transferable.getTransferData(it);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.ByteArray");
            byte[] bytes = (byte[])object;
            string = new String(bytes, this.charset);
        } else {
            string = null;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String readUsingFlavors(Transferable transferable) {
        Iterator iterator = ArrayIteratorKt.iterator((Object[])transferable.getTransferDataFlavors());
        while (iterator.hasNext()) {
            DataFlavor flavor = (DataFlavor)iterator.next();
            try {
                Closeable closeable = flavor.getReaderForText(transferable);
                Throwable throwable = null;
                try {
                    Reader reader = (Reader)closeable;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)reader);
                    String string = TextStreamsKt.readText((Reader)reader);
                    return string;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (IOException e) {
                Logger.debug((String)("Failed to read drop data using: " + flavor), (Throwable)e);
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final DataFlavor dataFlavorForType(Transferable $this$dataFlavorForType, Class<?> representationClass) {
        void $this$filterNotTo$iv$iv;
        void $this$filterNot$iv;
        void $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv2;
        Iterable $this$filter$iv;
        DataFlavor[] dataFlavorArray = $this$dataFlavorForType.getTransferDataFlavors();
        Intrinsics.checkNotNullExpressionValue((Object)dataFlavorArray, (String)"getTransferDataFlavors(...)");
        Object[] objectArray = dataFlavorArray;
        MimeType mimeType = this.getMimeType();
        boolean $i$f$filter22 = false;
        void var6_10 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (void element$iv$iv : $this$filterTo$iv$iv2) {
            DataFlavor p0 = (DataFlavor)element$iv$iv;
            boolean bl = false;
            if (!mimeType.matches(p0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter32 = false;
        Iterable $i$f$filter22 = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            DataFlavor it = (DataFlavor)element$iv$iv;
            boolean bl = false;
            if (!it.getRepresentationClass().isAssignableFrom(representationClass)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv2;
        CustomDataSupport $i$f$filter32 = CustomDataSupport.INSTANCE;
        boolean $i$f$filterNot = false;
        destination$iv$iv2 = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            DataFlavor p0 = (DataFlavor)element$iv$iv;
            boolean bl = false;
            if ($i$f$filter32.isCustomDataFlavor(p0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List flavors = (List)destination$iv$iv;
        boolean bl = false;
        DataFlavor dataFlavor = this.findForCharset(flavors);
        if (dataFlavor == null) {
            dataFlavor = (DataFlavor)CollectionsKt.firstOrNull((List)flavors);
        }
        return dataFlavor;
    }

    private final DataFlavor findForCharset(List<? extends DataFlavor> $this$findForCharset) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = $this$findForCharset;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                DataFlavor flavor = (DataFlavor)element$iv;
                boolean bl = false;
                String charsetParameter = flavor.getParameter("charset");
                if (!Intrinsics.areEqual((Object)this.charset.displayName(), (Object)charsetParameter)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }
}

