/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.compose.internal.render;

import androidx.compose.ui.unit.IntOffset;
import androidx.compose.ui.unit.IntOffsetKt;
import com.teamdev.jxbrowser.internal.AwtHelperLibrary;
import com.teamdev.jxbrowser.internal.Display;
import com.teamdev.jxbrowser.internal.ToolkitLibrary;
import com.teamdev.jxbrowser.os.Environment;
import java.awt.Window;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0018\u0010\u0005\u001a\u00020\u0006*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u001a\u0010\t\u001a\u0004\u0018\u00010\n*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"position", "Landroidx/compose/ui/unit/IntOffset;", "Ljava/awt/Window;", "getPosition", "(Ljava/awt/Window;)J", "displayId", "", "getDisplayId", "(Ljava/awt/Window;)Ljava/lang/String;", "nativeId", "", "getNativeId", "(Ljava/awt/Window;)Ljava/lang/Long;", "compose"})
public final class AwtWindowKt {
    public static final long getPosition(@NotNull Window $this$position) {
        Intrinsics.checkNotNullParameter((Object)$this$position, (String)"<this>");
        return $this$position.isVisible() ? IntOffsetKt.IntOffset((int)($this$position.getLocationOnScreen().x + $this$position.getInsets().left), (int)($this$position.getLocationOnScreen().y + $this$position.getInsets().top)) : IntOffset.Companion.getZero-nOcc-ac();
    }

    @NotNull
    public static final String getDisplayId(@NotNull Window $this$displayId) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$displayId, (String)"<this>");
        if (Environment.isLinux()) {
            String string2 = Display.primaryDisplay().id();
            Intrinsics.checkNotNull((Object)string2);
            string = string2;
        } else {
            Long id = AwtWindowKt.getNativeId($this$displayId);
            if (!(id != null)) {
                boolean bl = false;
                String string3 = "Can't obtain the display ID of a closed window.";
                throw new IllegalStateException(string3.toString());
            }
            String string4 = ToolkitLibrary.instance().getDisplayIdForWindow(id.longValue());
            Intrinsics.checkNotNull((Object)string4);
            string = string4;
        }
        return string;
    }

    @Nullable
    public static final Long getNativeId(@NotNull Window $this$nativeId) {
        Intrinsics.checkNotNullParameter((Object)$this$nativeId, (String)"<this>");
        return $this$nativeId.isDisplayable() ? Long.valueOf(AwtHelperLibrary.instance().getWindowHandle($this$nativeId)) : null;
    }
}

