/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser;

import com.teamdev.jxbrowser.logging.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public final class VersionInfo {
    private static final String UNKNOWN = "unknown";
    private static final String PRODUCT_VERSION = "product.version";
    private static final String CHROMIUM_VERSION = "chromium.version";
    private static final String PRODUCT_INFO_FILE_NAME = "version.info";
    private static Map<String, String> propertyMap = null;

    public static String version() {
        return VersionInfo.property(PRODUCT_VERSION);
    }

    public static String chromiumVersion() {
        return VersionInfo.property(CHROMIUM_VERSION);
    }

    private VersionInfo() {
    }

    private static synchronized Map<String, String> properties() {
        if (propertyMap == null) {
            HashMap propertyMapBuilder = new HashMap();
            Properties properties = new Properties();
            try (InputStream stream = VersionInfo.class.getResourceAsStream(PRODUCT_INFO_FILE_NAME);){
                if (stream != null) {
                    properties.load(stream);
                    Set<String> enumeration = properties.stringPropertyNames();
                    enumeration.forEach(propertyName -> propertyMapBuilder.put(propertyName, properties.getProperty((String)propertyName)));
                }
            }
            catch (IOException e) {
                Logger.error("Failed to read product info from the {0} file.", (Throwable)e, PRODUCT_INFO_FILE_NAME);
            }
            propertyMap = Map.copyOf(propertyMapBuilder);
        }
        return propertyMap;
    }

    private static String property(String key) {
        String value = VersionInfo.properties().get(key);
        if (value == null || value.isEmpty()) {
            return UNKNOWN;
        }
        return value;
    }
}

