/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.browser.callback;

import com.teamdev.jxbrowser.browser.callback.BrowserAsyncCallback;
import com.teamdev.jxbrowser.browser.callback.internal.PrintCallbackResponses;
import com.teamdev.jxbrowser.callback.AsyncCallbackAction;
import com.teamdev.jxbrowser.internal.Preconditions;
import com.teamdev.jxbrowser.print.PdfPrinter;
import com.teamdev.jxbrowser.print.Printer;
import com.teamdev.jxbrowser.print.Printers;
import com.teamdev.jxbrowser.print.SystemPrinter;
import com.teamdev.jxbrowser.print.internal.PrintTypes;
import com.teamdev.jxbrowser.print.internal.PrinterImpl;
import com.teamdev.jxbrowser.print.internal.PrintersImpl;
import com.teamdev.jxbrowser.print.internal.rpc.PrintPdf;
import java.util.function.Consumer;

public interface PrintPdfCallback
extends BrowserAsyncCallback<Params, Action> {

    public static final class Action
    extends AsyncCallbackAction<PrintPdf.Response> {
        public Action(Consumer<PrintPdf.Response> consumer) {
            super(consumer);
        }

        public void proceed(Printer<?> printer) {
            Preconditions.checkNotNull(printer);
            PrinterImpl printerImpl = (PrinterImpl)printer;
            printerImpl.applySettings();
            this.send(PrintCallbackResponses.printPdfResponse(printerImpl.printer()));
        }

        public void cancel() {
            this.send(PrintCallbackResponses.cancelPdfPrintingResponse());
        }
    }

    public static interface Params {
        default public Printers<PdfPrinter.PdfSettings, SystemPrinter.PdfSettings> printers() {
            return PrintersImpl.from(PrintTypes.cast(this));
        }
    }
}

