/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.browser.callback;

import com.teamdev.jxbrowser.browser.callback.BrowserAsyncCallback;
import com.teamdev.jxbrowser.callback.AsyncCallbackAction;
import com.teamdev.jxbrowser.internal.Preconditions;
import com.teamdev.jxbrowser.internal.rpc.FilePath;
import com.teamdev.jxbrowser.internal.rpc.Protobuf;
import com.teamdev.jxbrowser.internal.rpc.SaveAsPdf;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Consumer;

public interface SaveAsPdfCallback
extends BrowserAsyncCallback<Params, Action> {

    public static final class Action
    extends AsyncCallbackAction<SaveAsPdf.Response> {
        public Action(Consumer<SaveAsPdf.Response> consumer) {
            super(consumer);
        }

        public void save(Path filePath) {
            Preconditions.checkNotNull(filePath);
            this.send(SaveAsPdf.Response.newBuilder().setSaveFile(FilePath.newBuilder().setValue(filePath.toAbsolutePath().toString()).build()).build());
        }

        public void cancel() {
            this.send(SaveAsPdf.Response.newBuilder().setCancel(Protobuf.empty()).build());
        }
    }

    public static interface Params {
        default public String suggestedFileName() {
            return ((SaveAsPdf.Request)this).getSuggestedFileName().getValue();
        }

        default public Path suggestedDirectory() {
            return Paths.get(((SaveAsPdf.Request)this).getSuggestedDirectory().getValue(), new String[0]);
        }
    }
}

