/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.browser.callback;

import com.teamdev.jxbrowser.browser.callback.BrowserAsyncCallback;
import com.teamdev.jxbrowser.callback.AsyncCallbackAction;
import com.teamdev.jxbrowser.internal.Preconditions;
import com.teamdev.jxbrowser.internal.rpc.FilePath;
import com.teamdev.jxbrowser.internal.rpc.Protobuf;
import com.teamdev.jxbrowser.internal.rpc.SaveFile;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Consumer;

public interface SaveFileCallback
extends BrowserAsyncCallback<Params, Action> {

    public static final class Action
    extends AsyncCallbackAction<SaveFile.Response> {
        public Action(Consumer<SaveFile.Response> consumer) {
            super(consumer);
        }

        public void save(Path filePath) {
            Preconditions.checkNotNull(filePath);
            String absolutePath = filePath.toAbsolutePath().toString();
            this.send(SaveFile.Response.newBuilder().setSaveFile(FilePath.newBuilder().setValue(absolutePath).build()).build());
        }

        public void cancel() {
            this.send(SaveFile.Response.newBuilder().setCancel(Protobuf.empty()).build());
        }
    }

    public static interface Params {
        default public String suggestedFileName() {
            return SaveFile.Request.cast(this).getSuggestedFileName().getValue();
        }

        default public String suggestedDirectory() {
            return SaveFile.Request.cast(this).getSuggestedDirectory().getValue();
        }

        default public List<String> acceptableExtensions() {
            return List.copyOf(SaveFile.Request.cast(this).getAcceptableExtensionList());
        }

        default public String filterDescription() {
            return SaveFile.Request.cast(this).getFilterDescription();
        }

        default public boolean acceptAll() {
            return SaveFile.Request.cast(this).getAcceptAll();
        }
    }
}

