/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.browser.callback;

import com.teamdev.jxbrowser.annotation.Immutable;
import com.teamdev.jxbrowser.browser.callback.BrowserAsyncCallback;
import com.teamdev.jxbrowser.callback.AsyncCallbackAction;
import com.teamdev.jxbrowser.internal.Preconditions;
import com.teamdev.jxbrowser.internal.rpc.Protobuf;
import com.teamdev.jxbrowser.net.HostPort;
import com.teamdev.jxbrowser.net.internal.rpc.SelectClientCertificate;
import com.teamdev.jxbrowser.net.tls.Certificate;
import com.teamdev.jxbrowser.net.tls.ClientCertificate;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;

public interface SelectClientCertificateCallback
extends BrowserAsyncCallback<Params, Action> {

    public static final class Action
    extends AsyncCallbackAction<SelectClientCertificate.Response> {
        public Action(Consumer<SelectClientCertificate.Response> consumer) {
            super(consumer);
        }

        public void select(int index) {
            Preconditions.checkArgument(index >= 0);
            this.send(SelectClientCertificate.Response.newBuilder().setSelectCertificateWithIndex(index).build());
        }

        public void select(ClientCertificate clientCertificate) {
            Preconditions.checkNotNull(clientCertificate);
            this.send(SelectClientCertificate.Response.newBuilder().setSelectClientCertificate((com.teamdev.jxbrowser.net.internal.rpc.ClientCertificate)clientCertificate).build());
        }

        public void cancel() {
            this.send(SelectClientCertificate.Response.newBuilder().setCancel(Protobuf.empty()).build());
        }
    }

    public static interface Params {
        default public String title() {
            return ((SelectClientCertificate.Request)this).getTitle();
        }

        default public String message() {
            return ((SelectClientCertificate.Request)this).getMessage();
        }

        default public String selectActionText() {
            return ((SelectClientCertificate.Request)this).getSelectActionText();
        }

        default public String cancelActionText() {
            return ((SelectClientCertificate.Request)this).getCancelActionText();
        }

        default public boolean isProxy() {
            return ((SelectClientCertificate.Request)this).getIsProxy();
        }

        default public HostPort hostPort() {
            return ((SelectClientCertificate.Request)this).getHostPortPair();
        }

        @Immutable
        default public List<Certificate> certificates() {
            return Collections.unmodifiableList(((SelectClientCertificate.Request)this).getCertificateList());
        }
    }
}

