/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.browser.internal;

import com.teamdev.jxbrowser.browser.event.BrowserClosing;
import com.teamdev.jxbrowser.browser.event.FrameCreated;
import com.teamdev.jxbrowser.browser.event.FrameDeleted;
import com.teamdev.jxbrowser.browser.event.SpellCheckCompleted;
import com.teamdev.jxbrowser.browser.internal.BrowserImpl;
import com.teamdev.jxbrowser.browser.internal.RenderProcess;
import com.teamdev.jxbrowser.browser.internal.RenderProcesses;
import com.teamdev.jxbrowser.browser.internal.callback.StartRenderProcessCallback;
import com.teamdev.jxbrowser.browser.internal.callback.TerminateRenderProcessCallback;
import com.teamdev.jxbrowser.browser.internal.rpc.BrowserClosed;
import com.teamdev.jxbrowser.browser.internal.rpc.BrowserStub;
import com.teamdev.jxbrowser.browser.internal.rpc.OpenPopup;
import com.teamdev.jxbrowser.browser.internal.rpc.PopupCreatorStub;
import com.teamdev.jxbrowser.browser.internal.rpc.RenderProcessStarted;
import com.teamdev.jxbrowser.browser.internal.rpc.RenderProcessTerminated;
import com.teamdev.jxbrowser.browser.internal.rpc.RenderProcessesStub;
import com.teamdev.jxbrowser.browser.internal.rpc.StartRenderProcess;
import com.teamdev.jxbrowser.browser.internal.rpc.TerminateRenderProcess;
import com.teamdev.jxbrowser.browser.internal.rpc.WebPageStub;
import com.teamdev.jxbrowser.callback.Callback;
import com.teamdev.jxbrowser.capture.internal.CaptureSessions;
import com.teamdev.jxbrowser.capture.internal.rpc.CaptureSessionStarted;
import com.teamdev.jxbrowser.card.internal.rpc.CreditCardsStub;
import com.teamdev.jxbrowser.cast.internal.rpc.CastSessionsStub;
import com.teamdev.jxbrowser.download.internal.DownloadsImpl;
import com.teamdev.jxbrowser.download.internal.rpc.StartDownload;
import com.teamdev.jxbrowser.event.Event;
import com.teamdev.jxbrowser.extensions.internal.rpc.OpenExtensionActionPopup;
import com.teamdev.jxbrowser.frame.internal.callback.InjectCssCallback;
import com.teamdev.jxbrowser.frame.internal.callback.InjectJsCallback;
import com.teamdev.jxbrowser.internal.rpc.BrowserId;
import com.teamdev.jxbrowser.internal.rpc.ContextMenuServiceStub;
import com.teamdev.jxbrowser.internal.rpc.DialogsStub;
import com.teamdev.jxbrowser.internal.rpc.LocalServiceConnection;
import com.teamdev.jxbrowser.internal.rpc.ProcessId;
import com.teamdev.jxbrowser.internal.rpc.RenderProcessId;
import com.teamdev.jxbrowser.internal.rpc.Service;
import com.teamdev.jxbrowser.internal.rpc.ServiceConnectionImpl;
import com.teamdev.jxbrowser.internal.rpc.SuggestionsPopupServiceStub;
import com.teamdev.jxbrowser.internal.rpc.UniversalServiceConnection;
import com.teamdev.jxbrowser.internal.rpc.stream.Interceptor;
import com.teamdev.jxbrowser.internal.rpc.transport.Connection;
import com.teamdev.jxbrowser.js.internal.rpc.JsDialogsStub;
import com.teamdev.jxbrowser.media.internal.rpc.MediaDeviceManagerStub;
import com.teamdev.jxbrowser.navigation.TimeoutException;
import com.teamdev.jxbrowser.net.internal.rpc.CertificateErrorHandlerStub;
import com.teamdev.jxbrowser.net.internal.rpc.ClientCertificateChooserStub;
import com.teamdev.jxbrowser.password.internal.rpc.PasswordsStub;
import com.teamdev.jxbrowser.print.internal.rpc.PrintServiceStub;
import com.teamdev.jxbrowser.user.internal.rpc.UserDataProfilesStub;
import java.util.Set;

final class BrowserRpcConfig {
    private final BrowserId id;
    private final BrowserImpl browser;
    private final Connection connection;
    private final UniversalServiceConnection rpc;
    private final RenderProcesses renderProcesses;

    private BrowserRpcConfig(BrowserImpl browser, Connection connection) {
        this.id = browser.id();
        this.browser = browser;
        this.connection = connection;
        this.rpc = UniversalServiceConnection.with(connection).and(this.service(BrowserStub::new)).and(this.service(WebPageStub::new)).and(this.service(DialogsStub::new)).and(this.service(PasswordsStub::new)).and(this.service(UserDataProfilesStub::new)).and(this.service(CreditCardsStub::new)).and(this.service(PrintServiceStub::new)).and(this.service(JsDialogsStub::new)).and(this.service(PopupCreatorStub::new)).and(this.service(RenderProcessesStub::new)).and(this.service(ContextMenuServiceStub::new)).and(this.service(MediaDeviceManagerStub::new)).and(this.service(CertificateErrorHandlerStub::new)).and(this.service(SuggestionsPopupServiceStub::new)).and(this.service(ClientCertificateChooserStub::new)).and(this.service(CastSessionsStub::new)).and(new LocalServiceConnection(this.callbackTypes(), this.eventTypes())).and(browser.framesStub()).build();
        this.renderProcesses = browser.engine().renderProcesses();
    }

    static UniversalServiceConnection create(BrowserImpl browser, Connection connection) {
        BrowserRpcConfig config = new BrowserRpcConfig(browser, connection);
        return config.connect();
    }

    private <StubT extends Service> ServiceConnectionImpl<StubT> service(ServiceConnectionImpl.StubFactory<StubT> factory) {
        return new ServiceConnectionImpl<StubT>(this.id, this.connection, factory);
    }

    private UniversalServiceConnection connect() {
        this.rpc.setEventInterceptor(BrowserClosed.class, new BrowserImpl.ClosingHandler(this.browser));
        this.createRenderProcess();
        this.interceptPopups();
        this.interceptDownloads();
        this.interceptCaptureSessions();
        return this.rpc;
    }

    private void createRenderProcess() {
        this.rpc.set(StartRenderProcessCallback.class, params -> {
            RenderProcessStarted event = params.getEvent();
            RenderProcessId renderProcessId = event.getRenderProcessId();
            ProcessId pid = event.getRenderProcessPid();
            this.renderProcesses.add(this.renderProcess(event, renderProcessId, pid));
            this.browser.notifyObserversAsync(event);
            return StartRenderProcess.Response.newBuilder().build();
        });
        this.rpc.set(TerminateRenderProcessCallback.class, params -> {
            RenderProcessTerminated event = params.getEvent();
            this.renderProcesses.renderProcess(event.getRenderProcessId()).ifPresent(renderProcess -> {
                renderProcess.close();
                this.renderProcesses.remove((RenderProcess)renderProcess);
            });
            this.browser.notifyObserversAsync(event);
            return TerminateRenderProcess.Response.newBuilder().build();
        });
    }

    private RenderProcess renderProcess(RenderProcessStarted event, RenderProcessId renderProcessId, ProcessId pid) {
        Connection connection = this.browser.engine().connectionServer().awaitConnection(event.getConnectionId()).orElseThrow(() -> new TimeoutException("Failed to find connection within a timeout"));
        return new RenderProcess(connection, renderProcessId, pid);
    }

    private void interceptPopups() {
        this.rpc.setCallbackInterceptor(OpenPopup.Request.class, request -> {
            BrowserId popupBrowserId = request.getPopupBrowserId();
            new BrowserImpl(this.connection, this.browser.profile(), popupBrowserId);
            return Interceptor.Action.PROCEED;
        });
        this.rpc.setCallbackInterceptor(OpenExtensionActionPopup.Request.class, message -> {
            BrowserId popupBrowserId = message.getPopupBrowserId();
            new BrowserImpl(this.connection, this.browser.profile(), popupBrowserId);
            return Interceptor.Action.PROCEED;
        });
    }

    private void interceptDownloads() {
        this.rpc.setCallbackInterceptor(StartDownload.Request.class, request -> {
            DownloadsImpl downloads = this.browser.profile().downloads();
            downloads.register(request.getDownloadId(), request.getDownloadTarget());
            return Interceptor.Action.PROCEED;
        });
    }

    private void interceptCaptureSessions() {
        this.rpc.setEventInterceptor(CaptureSessionStarted.class, event -> {
            CaptureSessions contentCapture = this.browser.contentCaptureSessions();
            contentCapture.registerCaptureSession(event.getCaptureId(), event.getSource());
            return Interceptor.Action.PROCEED;
        });
    }

    private Set<Class<? extends Callback>> callbackTypes() {
        return Set.of(InjectCssCallback.class, InjectJsCallback.class);
    }

    private Set<Class<? extends Event>> eventTypes() {
        return Set.of(BrowserClosing.class, com.teamdev.jxbrowser.browser.event.RenderProcessStarted.class, com.teamdev.jxbrowser.browser.event.RenderProcessTerminated.class, FrameCreated.class, FrameDeleted.class, SpellCheckCompleted.class);
    }
}

