/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.browser.internal;

import com.teamdev.jxbrowser.Closeable;
import com.teamdev.jxbrowser.browser.callback.BrowserSyncCallback;
import com.teamdev.jxbrowser.browser.callback.input.CancelTouchCallback;
import com.teamdev.jxbrowser.browser.callback.input.EndTouchCallback;
import com.teamdev.jxbrowser.browser.callback.input.EnterMouseCallback;
import com.teamdev.jxbrowser.browser.callback.input.ExitMouseCallback;
import com.teamdev.jxbrowser.browser.callback.input.MoveMouseCallback;
import com.teamdev.jxbrowser.browser.callback.input.MoveMouseWheelCallback;
import com.teamdev.jxbrowser.browser.callback.input.MoveTouchCallback;
import com.teamdev.jxbrowser.browser.callback.input.PressKeyCallback;
import com.teamdev.jxbrowser.browser.callback.input.PressMouseCallback;
import com.teamdev.jxbrowser.browser.callback.input.ReleaseKeyCallback;
import com.teamdev.jxbrowser.browser.callback.input.ReleaseMouseCallback;
import com.teamdev.jxbrowser.browser.callback.input.StartTouchCallback;
import com.teamdev.jxbrowser.browser.callback.input.TypeKeyCallback;
import com.teamdev.jxbrowser.browser.event.internal.BrowserWidgetEvent;
import com.teamdev.jxbrowser.browser.event.internal.Painted;
import com.teamdev.jxbrowser.browser.internal.BrowserImpl;
import com.teamdev.jxbrowser.browser.internal.BrowserWidgetThread;
import com.teamdev.jxbrowser.browser.internal.Ime;
import com.teamdev.jxbrowser.browser.internal.callback.BrowserWidgetCallback;
import com.teamdev.jxbrowser.browser.internal.callback.PaintCallback;
import com.teamdev.jxbrowser.browser.internal.rpc.AccessibilityNode;
import com.teamdev.jxbrowser.browser.internal.rpc.AccessibilityToken;
import com.teamdev.jxbrowser.browser.internal.rpc.AssignHostWindowRequest;
import com.teamdev.jxbrowser.browser.internal.rpc.AttachAccessibleWindowRequest;
import com.teamdev.jxbrowser.browser.internal.rpc.AttachRequest;
import com.teamdev.jxbrowser.browser.internal.rpc.AttachResult;
import com.teamdev.jxbrowser.browser.internal.rpc.BrowserWidgetStub;
import com.teamdev.jxbrowser.browser.internal.rpc.Display;
import com.teamdev.jxbrowser.browser.internal.rpc.DragDropRequest;
import com.teamdev.jxbrowser.browser.internal.rpc.DragEndRequest;
import com.teamdev.jxbrowser.browser.internal.rpc.DragEnterRequest;
import com.teamdev.jxbrowser.browser.internal.rpc.DragLeaveRequest;
import com.teamdev.jxbrowser.browser.internal.rpc.DragOperation;
import com.teamdev.jxbrowser.browser.internal.rpc.DragOverRequest;
import com.teamdev.jxbrowser.browser.internal.rpc.DropData;
import com.teamdev.jxbrowser.browser.internal.rpc.DropMetadata;
import com.teamdev.jxbrowser.browser.internal.rpc.FocusRequest;
import com.teamdev.jxbrowser.browser.internal.rpc.GpuStub;
import com.teamdev.jxbrowser.browser.internal.rpc.ImeStub;
import com.teamdev.jxbrowser.browser.internal.rpc.KeyPressRequest;
import com.teamdev.jxbrowser.browser.internal.rpc.KeyReleaseRequest;
import com.teamdev.jxbrowser.browser.internal.rpc.KeyTypeRequest;
import com.teamdev.jxbrowser.browser.internal.rpc.MouseDragRequest;
import com.teamdev.jxbrowser.browser.internal.rpc.MouseEnterRequest;
import com.teamdev.jxbrowser.browser.internal.rpc.MouseExitRequest;
import com.teamdev.jxbrowser.browser.internal.rpc.MouseMoveRequest;
import com.teamdev.jxbrowser.browser.internal.rpc.MousePressRequest;
import com.teamdev.jxbrowser.browser.internal.rpc.MouseReleaseRequest;
import com.teamdev.jxbrowser.browser.internal.rpc.MouseWheelRequest;
import com.teamdev.jxbrowser.browser.internal.rpc.NativeKeyEventRequest;
import com.teamdev.jxbrowser.browser.internal.rpc.NativeMouseEventRequest;
import com.teamdev.jxbrowser.browser.internal.rpc.NativeTouchEventRequest;
import com.teamdev.jxbrowser.browser.internal.rpc.Paint;
import com.teamdev.jxbrowser.browser.internal.rpc.SetForcedScaleFactorRequest;
import com.teamdev.jxbrowser.browser.internal.rpc.SetParentAccessibilityNodesRequest;
import com.teamdev.jxbrowser.browser.internal.rpc.TouchCancelRequest;
import com.teamdev.jxbrowser.browser.internal.rpc.TouchEndRequest;
import com.teamdev.jxbrowser.browser.internal.rpc.TouchMoveRequest;
import com.teamdev.jxbrowser.browser.internal.rpc.TouchStartRequest;
import com.teamdev.jxbrowser.browser.internal.rpc.ViewBounds;
import com.teamdev.jxbrowser.browser.internal.rpc.WindowHandle;
import com.teamdev.jxbrowser.callback.Advisable;
import com.teamdev.jxbrowser.deps.com.google.protobuf.Empty;
import com.teamdev.jxbrowser.engine.RenderingMode;
import com.teamdev.jxbrowser.event.Observable;
import com.teamdev.jxbrowser.event.Observer;
import com.teamdev.jxbrowser.event.Subscription;
import com.teamdev.jxbrowser.frame.EditorCommand;
import com.teamdev.jxbrowser.internal.CloseableImpl;
import com.teamdev.jxbrowser.internal.Preconditions;
import com.teamdev.jxbrowser.internal.Wrappers;
import com.teamdev.jxbrowser.internal.reflect.Methods;
import com.teamdev.jxbrowser.internal.reflect.Types;
import com.teamdev.jxbrowser.internal.rpc.BrowserId;
import com.teamdev.jxbrowser.internal.rpc.ConnectionId;
import com.teamdev.jxbrowser.internal.rpc.ConnectionType;
import com.teamdev.jxbrowser.internal.rpc.DisplayId;
import com.teamdev.jxbrowser.internal.rpc.LocalServiceConnection;
import com.teamdev.jxbrowser.internal.rpc.ServiceConnection;
import com.teamdev.jxbrowser.internal.rpc.ServiceConnectionImpl;
import com.teamdev.jxbrowser.internal.rpc.UniversalServiceConnection;
import com.teamdev.jxbrowser.internal.rpc.event.ConnectionCreated;
import com.teamdev.jxbrowser.internal.rpc.transport.Connection;
import com.teamdev.jxbrowser.internal.rpc.transport.ConnectionServer;
import com.teamdev.jxbrowser.internal.rpc.transport.RpcCallback;
import com.teamdev.jxbrowser.internal.rpc.transport.RpcThread;
import com.teamdev.jxbrowser.internal.string.StringPreconditions;
import com.teamdev.jxbrowser.logging.Logger;
import com.teamdev.jxbrowser.os.Environment;
import com.teamdev.jxbrowser.ui.Point;
import com.teamdev.jxbrowser.ui.Rect;
import com.teamdev.jxbrowser.ui.Size;
import com.teamdev.jxbrowser.ui.event.KeyPressed;
import com.teamdev.jxbrowser.ui.event.KeyTyped;
import com.teamdev.jxbrowser.ui.event.MouseDragged;
import com.teamdev.jxbrowser.ui.event.MousePressed;
import com.teamdev.jxbrowser.ui.event.MouseWheel;
import com.teamdev.jxbrowser.ui.event.TouchEnded;
import com.teamdev.jxbrowser.ui.event.internal.rpc.CancelTouch;
import com.teamdev.jxbrowser.ui.event.internal.rpc.EndTouch;
import com.teamdev.jxbrowser.ui.event.internal.rpc.EnterMouse;
import com.teamdev.jxbrowser.ui.event.internal.rpc.ExitMouse;
import com.teamdev.jxbrowser.ui.event.internal.rpc.KeyModifiers;
import com.teamdev.jxbrowser.ui.event.internal.rpc.KeyReleased;
import com.teamdev.jxbrowser.ui.event.internal.rpc.MouseEntered;
import com.teamdev.jxbrowser.ui.event.internal.rpc.MouseExited;
import com.teamdev.jxbrowser.ui.event.internal.rpc.MouseMoved;
import com.teamdev.jxbrowser.ui.event.internal.rpc.MouseReleased;
import com.teamdev.jxbrowser.ui.event.internal.rpc.MoveMouse;
import com.teamdev.jxbrowser.ui.event.internal.rpc.MoveMouseWheel;
import com.teamdev.jxbrowser.ui.event.internal.rpc.MoveTouch;
import com.teamdev.jxbrowser.ui.event.internal.rpc.NativeKeyEvent;
import com.teamdev.jxbrowser.ui.event.internal.rpc.NativeMouseEvent;
import com.teamdev.jxbrowser.ui.event.internal.rpc.NativeWindowsTouchEvent;
import com.teamdev.jxbrowser.ui.event.internal.rpc.PressKey;
import com.teamdev.jxbrowser.ui.event.internal.rpc.PressMouse;
import com.teamdev.jxbrowser.ui.event.internal.rpc.ReleaseKey;
import com.teamdev.jxbrowser.ui.event.internal.rpc.ReleaseMouse;
import com.teamdev.jxbrowser.ui.event.internal.rpc.StartTouch;
import com.teamdev.jxbrowser.ui.event.internal.rpc.TouchCanceled;
import com.teamdev.jxbrowser.ui.event.internal.rpc.TouchMoved;
import com.teamdev.jxbrowser.ui.event.internal.rpc.TouchStarted;
import com.teamdev.jxbrowser.ui.event.internal.rpc.TypeKey;
import com.teamdev.jxbrowser.ui.internal.MacEditorCommand;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;

public final class BrowserWidget
extends CloseableImpl
implements Advisable<BrowserWidgetCallback>,
Observable<BrowserWidgetEvent> {
    private final BrowserImpl browser;
    private final UniversalServiceConnection rpc;
    private final ConnectionServer connectionServer;
    private final ServiceConnection<GpuStub> mainRpc;
    private final BrowserWidgetThread widgetThread;
    private ServiceConnection<GpuStub> gpu;
    private final Subscription onConnectionCreated;
    private final Ime ime;

    BrowserWidget(BrowserImpl browser) {
        Preconditions.checkNotNull(browser);
        this.browser = browser;
        this.widgetThread = new BrowserWidgetThread(this.browserId().getUuid());
        Connection connection = browser.engine().connection();
        this.rpc = UniversalServiceConnection.with(connection).and(new ServiceConnectionImpl<BrowserWidgetStub>(browser.id(), connection, BrowserWidgetStub::new)).and(new ServiceConnectionImpl<ImeStub>(browser.id(), connection, ImeStub::new)).and(new LocalServiceConnection(Set.of(PaintCallback.class), Set.of(Painted.class))).build();
        this.mainRpc = new ServiceConnectionImpl<GpuStub>(browser.id(), connection, GpuStub::new);
        this.mainRpc.set(PaintCallback.class, params -> this.rpc.get(PaintCallback.class).map(callback -> (Paint.Response)callback.on(params)).orElse(Paint.Response.getDefaultInstance()));
        this.connectionServer = browser.engine().connectionServer();
        this.onConnectionCreated = this.connectionServer.on(ConnectionCreated.class, this::onConnectionCreated);
        this.connectionServer.getConnection(ConnectionType.GPU).ifPresent(this::onGpuConnectionCreated);
        this.ime = new Ime(this);
    }

    private void onConnectionCreated(ConnectionCreated event) {
        if (event.connection().type().equals(ConnectionType.GPU)) {
            ConnectionId connectionId = event.connection().id();
            this.connectionServer.awaitConnection(connectionId).ifPresent(this::onGpuConnectionCreated);
        }
    }

    private void onGpuConnectionCreated(Connection connection) {
        this.gpu().ifPresent(Closeable::close);
        this.gpu = new ServiceConnectionImpl<GpuStub>(this.browserId(), connection, GpuStub::new);
        this.gpu.set(PaintCallback.class, params -> this.rpc.get(PaintCallback.class).map(callback -> (Paint.Response)callback.on(params)).orElse(Paint.Response.getDefaultInstance()));
    }

    private void submit(Runnable task) {
        this.widgetThread.submit(task);
    }

    private <T> Optional<T> execute(Callable<T> task) {
        return this.widgetThread.execute(task);
    }

    private void execute(Runnable task) {
        this.widgetThread.execute(task);
    }

    public UniversalServiceConnection rpc() {
        return this.rpc;
    }

    private Optional<ServiceConnection<GpuStub>> gpu() {
        return Optional.ofNullable(this.gpu);
    }

    public BrowserImpl browser() {
        return this.browser;
    }

    private BrowserId browserId() {
        return this.browser.id();
    }

    public void focus() {
        this.focus(FocusRequest.Cause.FOCUS_CASE_UNSPECIFIED);
    }

    public void focus(FocusRequest.Cause cause) {
        this.submit(() -> {
            FocusRequest request = FocusRequest.newBuilder().setBrowserId(this.browserId()).setCause(cause).build();
            this.rpc.invokeAsync(this.rpc.stub(BrowserWidgetStub.class)::focus, request);
        });
    }

    public void unfocus() {
        this.submit(() -> this.rpc.invokeAsync(this.rpc.stub(BrowserWidgetStub.class)::unfocus, this.browserId()));
    }

    public void assignHostWindow(long windowHandle) {
        this.submit(() -> {
            WindowHandle handle = WindowHandle.newBuilder().setValue(windowHandle).build();
            AssignHostWindowRequest request = AssignHostWindowRequest.newBuilder().setBrowserId(this.browserId()).setWindowHandle(handle).build();
            this.rpc.invokeAsync(this.rpc.stub(BrowserWidgetStub.class)::assignHostWindow, request);
        });
    }

    public void show() {
        this.submit(() -> this.rpc.invokeAsync(this.rpc.stub(BrowserWidgetStub.class)::show, this.browserId()));
    }

    public void hide() {
        this.submit(() -> this.rpc.invokeAsync(this.rpc.stub(BrowserWidgetStub.class)::hide, this.browserId()));
    }

    public void minimize() {
        this.submit(() -> this.rpc.invokeAsync(this.rpc.stub(BrowserWidgetStub.class)::minimize, this.browserId()));
    }

    public void restore() {
        this.submit(() -> this.rpc.invokeAsync(this.rpc.stub(BrowserWidgetStub.class)::restore, this.browserId()));
    }

    public void bounds(Rect boundsInWindow, Rect boundsInScreen) {
        Preconditions.checkNotNull(boundsInWindow);
        Preconditions.checkNotNull(boundsInScreen);
        this.submit(() -> {
            ViewBounds request = ViewBounds.newBuilder().setBrowserId(this.browserId()).setBoundsInWindow(Wrappers.unwrap(boundsInWindow, com.teamdev.jxbrowser.ui.internal.rpc.Rect.class)).setBoundsInScreen(Wrappers.unwrap(boundsInScreen, com.teamdev.jxbrowser.ui.internal.rpc.Rect.class)).build();
            this.rpc.invokeAsync(this.rpc.stub(BrowserWidgetStub.class)::setViewBounds, request);
        });
    }

    public void attach(long windowHandle) {
        this.attach(windowHandle, () -> {}, () -> {}, Size.empty());
    }

    public void attach(long windowHandle, final Runnable onAttached, final Runnable onFailed, Size initialSize) {
        this.submit(() -> {
            WindowHandle handle = WindowHandle.newBuilder().setValue(windowHandle).build();
            AttachRequest request = AttachRequest.newBuilder().setBrowserId(this.browserId()).setWindowHandle(handle).setInitialSize(com.teamdev.jxbrowser.ui.internal.rpc.Size.cast(initialSize)).build();
            this.rpc.invokeAsync(this.rpc.stub(BrowserWidgetStub.class)::attach, request, new RpcCallback<AttachResult>(){

                @Override
                public void onNext(AttachResult result) {
                    if (result.getSuccess()) {
                        onAttached.run();
                    } else {
                        Logger.error("Failed to attach the window.");
                        onFailed.run();
                    }
                }
            });
        });
    }

    public void detach() {
        Preconditions.checkState(Environment.isLinux());
        this.execute(() -> (Empty)this.rpc.invoke(this.rpc.stub(BrowserWidgetStub.class)::detach, this.browserId()));
    }

    public Optional<WindowHandle> chromiumWindowHandle() {
        return this.execute(() -> (WindowHandle)this.rpc.invoke(this.rpc.stub(BrowserWidgetStub.class)::getChromiumWindowHandle, this.browserId()));
    }

    public Optional<AccessibilityToken> accessibilityToken() {
        Preconditions.checkState(Environment.isMac());
        try {
            AccessibilityToken token = (AccessibilityToken)this.rpc.invoke(this.rpc.stub(BrowserWidgetStub.class)::getAccessibilityToken, this.browserId());
            return Optional.of(token);
        }
        catch (IllegalStateException e) {
            return Optional.empty();
        }
    }

    public void setParentAccessibilityNodes(AccessibilityNode windowNode, AccessibilityNode viewNode) {
        Preconditions.checkState(Environment.isMac());
        this.submit(() -> {
            SetParentAccessibilityNodesRequest setParentAccessibilityNodesRequest = SetParentAccessibilityNodesRequest.newBuilder().setId(this.browserId()).setViewNode(viewNode).setWindowNode(windowNode).build();
            this.rpc.invokeAsync(this.rpc.stub(BrowserWidgetStub.class)::setParentAccessibilityNodes, setParentAccessibilityNodesRequest);
        });
    }

    public void attachAccessibleWindow(long windowHandle) {
        Preconditions.checkState(Environment.isWindows());
        this.submit(() -> {
            AttachAccessibleWindowRequest request = AttachAccessibleWindowRequest.newBuilder().setBrowserId(this.browserId()).setWindowHandle(WindowHandle.newBuilder().setValue(windowHandle).build()).build();
            this.rpc.invokeAsync(this.rpc.stub(BrowserWidgetStub.class)::attachAccessibleWindow, request);
        });
    }

    public void setForcedScaleFactor(double scaleFactor) {
        Preconditions.checkState(Environment.isLinux());
        this.submit(() -> {
            SetForcedScaleFactorRequest request = SetForcedScaleFactorRequest.newBuilder().setBrowserId(this.browserId()).setScaleFactor(scaleFactor).build();
            this.rpc.invoke(this.rpc.stub(BrowserWidgetStub.class)::setForcedScaleFactor, request);
        });
    }

    public void notifyParentWindowChanged(long windowHandle, Size size) {
        Preconditions.checkState(Environment.isLinux());
        this.submit(() -> {
            WindowHandle handle = WindowHandle.newBuilder().setValue(windowHandle).build();
            AttachRequest request = AttachRequest.newBuilder().setBrowserId(this.browserId()).setWindowHandle(handle).setInitialSize(com.teamdev.jxbrowser.ui.internal.rpc.Size.cast(size)).build();
            this.rpc.invokeAsync(this.rpc.stub(BrowserWidgetStub.class)::notifyParentWindowChanged, request);
        });
    }

    public void displayId(String displayId) {
        StringPreconditions.checkNotNullEmptyOrBlank(displayId);
        this.submit(() -> {
            Display request = Display.newBuilder().setBrowserId(this.browserId()).setDisplayId(DisplayId.newBuilder().setValue(displayId).build()).build();
            this.rpc.invokeAsync(this.rpc.stub(BrowserWidgetStub.class)::setDisplay, request);
        });
    }

    private <C extends BrowserSyncCallback, M, E> boolean suppress(Class<C> callbackClass, Class<M> messageClass, E event) {
        if (!Environment.isMac() && this.browser.engine().options().renderingMode() == RenderingMode.HARDWARE_ACCELERATED) {
            return false;
        }
        return this.browser.get(callbackClass).map(callback -> {
            RpcThread rpcThread = this.rpc.connection().rpcThread();
            Callable<Boolean> task = () -> {
                Class<?> requestClass = Types.findDeclaredClass(messageClass, "Request").orElseThrow(() -> new IllegalArgumentException("The callback class does not declare 'Request' class: " + String.valueOf(callbackClass)));
                Class<?> responseClass = Types.findDeclaredClass(messageClass, "Response").orElseThrow(() -> new IllegalArgumentException("The callback class does not declare 'Response' class: " + String.valueOf(callbackClass)));
                Method newBuilder = Methods.getMethod(requestClass, "newBuilder", new Class[0]);
                Object builder = Methods.invokeStatic(newBuilder, new Object[0]);
                Method setEvent = Methods.getMethod(builder.getClass(), "setEvent", event.getClass());
                Methods.invoke(builder, setEvent, event);
                Method build = Methods.getMethod(builder.getClass(), "build", new Class[0]);
                Object params = Methods.invoke(builder, build, new Object[0]);
                Object response = callback.on(params);
                if (response != null) {
                    Method getSuppress = Methods.getMethod(responseClass, "getSuppress", new Class[0]);
                    return (Boolean)Methods.invoke(response, getSuppress, new Object[0]);
                }
                return false;
            };
            try {
                return rpcThread.isCurrentlyOn() ? task.call() : rpcThread.execute(task);
            }
            catch (Exception e) {
                Logger.error("An exception occurred during processing the callback.", e);
                return false;
            }
        }).orElse(false);
    }

    public void dispatch(NativeKeyEvent keyEvent) {
        this.submit(() -> {
            NativeKeyEventRequest request = NativeKeyEventRequest.newBuilder().setBrowserId(this.browserId()).setKeyEvent(keyEvent).build();
            this.rpc.invokeAsync(this.rpc.stub(BrowserWidgetStub.class)::forwardNativeKeyEvent, request);
        });
    }

    public void dispatch(NativeWindowsTouchEvent touchEvent) {
        this.submit(() -> {
            NativeTouchEventRequest request = NativeTouchEventRequest.newBuilder().setBrowserId(this.browserId()).setTouchEvent(touchEvent).build();
            this.rpc.invokeAsync(this.rpc.stub(BrowserWidgetStub.class)::forwardNativeTouchEvent, request);
        });
    }

    public void dispatch(NativeMouseEvent mouseEvent) {
        this.submit(() -> {
            NativeMouseEventRequest request = NativeMouseEventRequest.newBuilder().setBrowserId(this.browserId()).setMouseEvent(mouseEvent).build();
            this.rpc.invokeAsync(this.rpc.stub(BrowserWidgetStub.class)::forwardNativeMouseEvent, request);
        });
    }

    public void dispatch(KeyPressed event) {
        Preconditions.checkNotNull(event);
        this.submit(() -> {
            com.teamdev.jxbrowser.ui.event.internal.rpc.KeyPressed keyPressed = Wrappers.unwrap(event, com.teamdev.jxbrowser.ui.event.internal.rpc.KeyPressed.class);
            if (this.suppress(PressKeyCallback.class, PressKey.class, keyPressed)) {
                return;
            }
            KeyPressRequest request = KeyPressRequest.newBuilder().setBrowserId(this.browserId()).setKeyPressed(keyPressed).build();
            this.rpc.invokeAsync(this.rpc.stub(BrowserWidgetStub.class)::forwardKeyPress, request);
            if (Environment.isMac()) {
                MacEditorCommand.of(event).ifPresent(editorCommand -> this.browser.focusedFrame().ifPresent(focusedFrame -> focusedFrame.execute((EditorCommand)editorCommand)));
            }
        });
    }

    public void dispatch(com.teamdev.jxbrowser.ui.event.KeyReleased event) {
        Preconditions.checkNotNull(event);
        this.submit(() -> {
            KeyReleased keyReleased = Wrappers.unwrap(event, KeyReleased.class);
            if (this.suppress(ReleaseKeyCallback.class, ReleaseKey.class, keyReleased)) {
                return;
            }
            KeyReleaseRequest request = KeyReleaseRequest.newBuilder().setBrowserId(this.browserId()).setKeyReleased(keyReleased).build();
            this.rpc.invokeAsync(this.rpc.stub(BrowserWidgetStub.class)::forwardKeyRelease, request);
        });
    }

    public void dispatch(KeyTyped event) {
        Preconditions.checkNotNull(event);
        this.submit(() -> {
            com.teamdev.jxbrowser.ui.event.internal.rpc.KeyTyped keyTyped = Wrappers.unwrap(event, com.teamdev.jxbrowser.ui.event.internal.rpc.KeyTyped.class);
            if (this.suppress(TypeKeyCallback.class, TypeKey.class, keyTyped)) {
                return;
            }
            KeyTypeRequest request = KeyTypeRequest.newBuilder().setBrowserId(this.browserId()).setKeyTyped(keyTyped).build();
            this.rpc.invokeAsync(this.rpc.stub(BrowserWidgetStub.class)::forwardKeyType, request);
        });
    }

    public void dispatch(MousePressed event) {
        Preconditions.checkNotNull(event);
        this.submit(() -> {
            com.teamdev.jxbrowser.ui.event.internal.rpc.MousePressed mousePressed = Wrappers.unwrap(event, com.teamdev.jxbrowser.ui.event.internal.rpc.MousePressed.class);
            if (this.suppress(PressMouseCallback.class, PressMouse.class, mousePressed)) {
                return;
            }
            MousePressRequest request = MousePressRequest.newBuilder().setBrowserId(this.browserId()).setMousePressed(mousePressed).build();
            this.rpc.invokeAsync(this.rpc.stub(BrowserWidgetStub.class)::forwardMousePress, request);
        });
    }

    public void dispatch(com.teamdev.jxbrowser.ui.event.MouseReleased event) {
        Preconditions.checkNotNull(event);
        this.submit(() -> {
            MouseReleased mouseReleased = Wrappers.unwrap(event, MouseReleased.class);
            if (this.suppress(ReleaseMouseCallback.class, ReleaseMouse.class, mouseReleased)) {
                return;
            }
            MouseReleaseRequest request = MouseReleaseRequest.newBuilder().setBrowserId(this.browserId()).setMouseReleased(mouseReleased).build();
            this.rpc.invokeAsync(this.rpc.stub(BrowserWidgetStub.class)::forwardMouseRelease, request);
        });
    }

    public void dispatch(com.teamdev.jxbrowser.ui.event.MouseEntered event) {
        Preconditions.checkNotNull(event);
        this.submit(() -> {
            MouseEntered mouseEntered = Wrappers.unwrap(event, MouseEntered.class);
            if (this.suppress(EnterMouseCallback.class, EnterMouse.class, mouseEntered)) {
                return;
            }
            MouseEnterRequest request = MouseEnterRequest.newBuilder().setBrowserId(this.browserId()).setMouseEntered(mouseEntered).build();
            this.rpc.invokeAsync(this.rpc.stub(BrowserWidgetStub.class)::forwardMouseEnter, request);
        });
    }

    public void dispatch(com.teamdev.jxbrowser.ui.event.MouseExited event) {
        Preconditions.checkNotNull(event);
        this.submit(() -> {
            MouseExited mouseExited = Wrappers.unwrap(event, MouseExited.class);
            if (this.suppress(ExitMouseCallback.class, ExitMouse.class, mouseExited)) {
                return;
            }
            MouseExitRequest request = MouseExitRequest.newBuilder().setBrowserId(this.browserId()).setMouseExited(mouseExited).build();
            this.rpc.invokeAsync(this.rpc.stub(BrowserWidgetStub.class)::forwardMouseExit, request);
        });
    }

    public void dispatch(MouseDragged event) {
        Preconditions.checkNotNull(event);
        this.submit(() -> {
            com.teamdev.jxbrowser.ui.event.internal.rpc.MouseDragged mouseDragged = Wrappers.unwrap(event, com.teamdev.jxbrowser.ui.event.internal.rpc.MouseDragged.class);
            MouseMoved mouseMoved = MouseMoved.newBuilder().setLocation(mouseDragged.getLocation()).setLocationOnScreen(mouseDragged.getLocationOnScreen()).build();
            if (this.suppress(MoveMouseCallback.class, MoveMouse.class, mouseMoved)) {
                return;
            }
            MouseDragRequest request = MouseDragRequest.newBuilder().setBrowserId(this.browserId()).setMouseDragged(mouseDragged).build();
            this.rpc.invokeAsync(this.rpc.stub(BrowserWidgetStub.class)::forwardMouseDrag, request);
        });
    }

    public void dispatch(com.teamdev.jxbrowser.ui.event.MouseMoved event) {
        Preconditions.checkNotNull(event);
        this.submit(() -> {
            MouseMoved mouseMoved = Wrappers.unwrap(event, MouseMoved.class);
            if (this.suppress(MoveMouseCallback.class, MoveMouse.class, mouseMoved)) {
                return;
            }
            MouseMoveRequest request = MouseMoveRequest.newBuilder().setBrowserId(this.browserId()).setMouseMoved(mouseMoved).build();
            this.rpc.invokeAsync(this.rpc.stub(BrowserWidgetStub.class)::forwardMouseMove, request);
        });
    }

    public void dispatch(MouseWheel event) {
        Preconditions.checkNotNull(event);
        this.submit(() -> {
            com.teamdev.jxbrowser.ui.event.internal.rpc.MouseWheel mouseWheel = Wrappers.unwrap(event, com.teamdev.jxbrowser.ui.event.internal.rpc.MouseWheel.class);
            if (this.suppress(MoveMouseWheelCallback.class, MoveMouseWheel.class, mouseWheel)) {
                return;
            }
            MouseWheelRequest request = MouseWheelRequest.newBuilder().setBrowserId(this.browserId()).setMouseWheel(mouseWheel).build();
            this.rpc.invokeAsync(this.rpc.stub(BrowserWidgetStub.class)::forwardMouseWheel, request);
        });
    }

    public void dispatch(com.teamdev.jxbrowser.ui.event.TouchStarted event) {
        Preconditions.checkNotNull(event);
        this.submit(() -> {
            TouchStarted touchStarted = Wrappers.unwrap(event, TouchStarted.class);
            if (this.suppress(StartTouchCallback.class, StartTouch.class, touchStarted)) {
                return;
            }
            TouchStartRequest request = TouchStartRequest.newBuilder().setBrowserId(this.browserId()).setTouchStarted(touchStarted).build();
            this.rpc.invokeAsync(this.rpc.stub(BrowserWidgetStub.class)::forwardTouchStart, request);
        });
    }

    public void dispatch(com.teamdev.jxbrowser.ui.event.TouchMoved event) {
        Preconditions.checkNotNull(event);
        this.submit(() -> {
            TouchMoved touchMoved = Wrappers.unwrap(event, TouchMoved.class);
            if (this.suppress(MoveTouchCallback.class, MoveTouch.class, touchMoved)) {
                return;
            }
            TouchMoveRequest request = TouchMoveRequest.newBuilder().setBrowserId(this.browserId()).setTouchMoved(touchMoved).build();
            this.rpc.invokeAsync(this.rpc.stub(BrowserWidgetStub.class)::forwardTouchMove, request);
        });
    }

    public void dispatch(TouchEnded event) {
        Preconditions.checkNotNull(event);
        this.submit(() -> {
            com.teamdev.jxbrowser.ui.event.internal.rpc.TouchEnded touchEnded = Wrappers.unwrap(event, com.teamdev.jxbrowser.ui.event.internal.rpc.TouchEnded.class);
            if (this.suppress(EndTouchCallback.class, EndTouch.class, touchEnded)) {
                return;
            }
            TouchEndRequest request = TouchEndRequest.newBuilder().setBrowserId(this.browserId()).setTouchEnded(touchEnded).build();
            this.rpc.invokeAsync(this.rpc.stub(BrowserWidgetStub.class)::forwardTouchEnd, request);
        });
    }

    public void dispatch(com.teamdev.jxbrowser.ui.event.TouchCanceled event) {
        Preconditions.checkNotNull(event);
        this.submit(() -> {
            TouchCanceled touchCanceled = Wrappers.unwrap(event, TouchCanceled.class);
            if (this.suppress(CancelTouchCallback.class, CancelTouch.class, touchCanceled)) {
                return;
            }
            TouchCancelRequest request = TouchCancelRequest.newBuilder().setBrowserId(this.browserId()).setTouchCanceled(touchCanceled).build();
            this.rpc.invokeAsync(this.rpc.stub(BrowserWidgetStub.class)::forwardTouchCancel, request);
        });
    }

    public void dragEnter(DropMetadata dropMetadata, Point location, Point screenLocation, int operationsAllowed, KeyModifiers keyModifiers) {
        Preconditions.checkNotNull(screenLocation);
        Preconditions.checkNotNull(dropMetadata);
        Preconditions.checkNotNull(location);
        this.submit(() -> {
            DragEnterRequest request = DragEnterRequest.newBuilder().setBrowserId(this.browserId()).setKeyModifiers(keyModifiers).setDropMetadata(dropMetadata).setLocation(Wrappers.unwrap(location, com.teamdev.jxbrowser.ui.internal.rpc.Point.class)).setScreenLocation(Wrappers.unwrap(screenLocation, com.teamdev.jxbrowser.ui.internal.rpc.Point.class)).setOperationsAllowed(operationsAllowed).build();
            this.rpc.invokeAsync(this.rpc.stub(BrowserWidgetStub.class)::forwardDragEnter, request);
        });
    }

    public void dragOver(Point location, Point screenLocation, int operationsAllowed, KeyModifiers keyModifiers) {
        Preconditions.checkNotNull(location);
        Preconditions.checkNotNull(screenLocation);
        this.submit(() -> {
            DragOverRequest request = DragOverRequest.newBuilder().setBrowserId(this.browserId()).setKeyModifiers(keyModifiers).setLocation(Wrappers.unwrap(location, com.teamdev.jxbrowser.ui.internal.rpc.Point.class)).setScreenLocation(Wrappers.unwrap(screenLocation, com.teamdev.jxbrowser.ui.internal.rpc.Point.class)).setOperationsAllowed(operationsAllowed).build();
            this.rpc.invokeAsync(this.rpc.stub(BrowserWidgetStub.class)::forwardDragOver, request);
        });
    }

    public void dragLeave() {
        this.submit(() -> {
            DragLeaveRequest request = DragLeaveRequest.newBuilder().setBrowserId(this.browserId()).build();
            this.rpc.invokeAsync(this.rpc.stub(BrowserWidgetStub.class)::forwardDragLeave, request);
        });
    }

    public void drop(DropData dropData, Point location, Point screenLocation, KeyModifiers keyModifiers) {
        Preconditions.checkNotNull(dropData);
        Preconditions.checkNotNull(location);
        Preconditions.checkNotNull(screenLocation);
        this.submit(() -> {
            DragDropRequest request = DragDropRequest.newBuilder().setBrowserId(this.browserId()).setDropData(dropData).setKeyModifiers(keyModifiers).setLocation(Wrappers.unwrap(location, com.teamdev.jxbrowser.ui.internal.rpc.Point.class)).setScreenLocation(Wrappers.unwrap(screenLocation, com.teamdev.jxbrowser.ui.internal.rpc.Point.class)).build();
            this.rpc.invokeAsync(this.rpc.stub(BrowserWidgetStub.class)::forwardDragDrop, request);
        });
    }

    public void dragEnd(Point location, Point screenLocation, DragOperation operation) {
        Preconditions.checkNotNull(location);
        Preconditions.checkNotNull(screenLocation);
        this.submit(() -> {
            DragEndRequest request = DragEndRequest.newBuilder().setBrowserId(this.browserId()).setLocation(Wrappers.unwrap(location, com.teamdev.jxbrowser.ui.internal.rpc.Point.class)).setScreenLocation(Wrappers.unwrap(screenLocation, com.teamdev.jxbrowser.ui.internal.rpc.Point.class)).setOperation(operation).build();
            this.rpc.invokeAsync(this.rpc.stub(BrowserWidgetStub.class)::forwardDragEnd, request);
        });
    }

    public void requestLastRenderedFrame() {
        this.submit(() -> this.gpu().ifPresent(gpu -> {
            try {
                gpu.invokeAsync(((GpuStub)gpu.stub())::resendLastFrame, this.browserId());
            }
            catch (IllegalStateException ignored) {
                Logger.debug("The GPU connection is already closed.");
            }
        }));
    }

    public void onPainted() {
        this.rpc.dispatch(new Painted(){});
    }

    @Override
    public <E extends BrowserWidgetEvent> Subscription on(Class<E> eventClass, Observer<E> observer) {
        return this.rpc.on(eventClass, observer);
    }

    @Override
    public void close() {
        this.execute(() -> {
            this.onConnectionCreated.unsubscribe();
            this.rpc.close();
            this.mainRpc.close();
            this.ime.close();
            this.gpu().ifPresent(Closeable::close);
            super.close();
            this.widgetThread.shutdownNow();
        });
    }

    @Override
    public <C extends BrowserWidgetCallback> C set(Class<C> callbackClass, C callback) {
        return (C)((BrowserWidgetCallback)this.rpc.set(callbackClass, callback));
    }

    @Override
    public <C extends BrowserWidgetCallback> Optional<C> get(Class<C> callbackClass) {
        return this.rpc.get(callbackClass);
    }

    @Override
    public <C extends BrowserWidgetCallback> C remove(Class<C> callbackClass) {
        return (C)((BrowserWidgetCallback)this.rpc.remove(callbackClass));
    }

    public Ime ime() {
        return this.ime;
    }
}

