/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.cast.internal;

import com.teamdev.jxbrowser.cast.CastMode;
import com.teamdev.jxbrowser.cast.CastSession;
import com.teamdev.jxbrowser.cast.MediaReceiver;
import com.teamdev.jxbrowser.cast.internal.MediaReceiverImpl;
import com.teamdev.jxbrowser.cast.internal.MediaReceiversImpl;
import com.teamdev.jxbrowser.cast.internal.rpc.CastSessionDetailsRequest;
import com.teamdev.jxbrowser.cast.internal.rpc.CastSessionInfo;
import com.teamdev.jxbrowser.cast.internal.rpc.CastSessionStopped;
import com.teamdev.jxbrowser.cast.internal.rpc.CastSessionStub;
import com.teamdev.jxbrowser.cast.internal.rpc.StopCastSessionRequest;
import com.teamdev.jxbrowser.deps.com.google.protobuf.BoolValue;
import com.teamdev.jxbrowser.deps.com.google.protobuf.StringValue;
import com.teamdev.jxbrowser.event.Observer;
import com.teamdev.jxbrowser.event.Subscription;
import com.teamdev.jxbrowser.internal.CloseableImpl;
import com.teamdev.jxbrowser.internal.Preconditions;
import com.teamdev.jxbrowser.internal.rpc.CastSessionId;
import com.teamdev.jxbrowser.internal.rpc.MediaReceiverId;
import com.teamdev.jxbrowser.internal.rpc.ServiceConnectionImpl;
import com.teamdev.jxbrowser.internal.rpc.stream.Interceptor;
import com.teamdev.jxbrowser.profile.Profile;
import com.teamdev.jxbrowser.profile.internal.ProfileImpl;

public final class CastSessionImpl
extends CloseableImpl
implements CastSession {
    private final CastSessionInfo castSessionInfo;
    private final ServiceConnectionImpl<CastSessionStub> rpc;
    private final ProfileImpl profile;
    private final MediaReceiverImpl receiver;

    public CastSessionImpl(CastSessionInfo castSessionInfo, ProfileImpl profile) {
        Preconditions.checkNotNull(castSessionInfo);
        Preconditions.checkNotNull(profile);
        this.castSessionInfo = castSessionInfo;
        this.profile = profile;
        MediaReceiversImpl receivers = profile.mediaCasting().mediaReceivers();
        this.rpc = new ServiceConnectionImpl<CastSessionStub>(castSessionInfo.getId(), profile.engine().connection(), CastSessionStub::new);
        this.rpc.setEventInterceptor(CastSessionStopped.class, event -> {
            this.rpc.dispatch(event);
            profile.mediaCasting().castSessions().removeCastSession(castSessionInfo.getId());
            return Interceptor.Action.CANCEL;
        });
        this.receiver = receivers.byId(castSessionInfo.getReceiverId()).orElse(null);
    }

    CastSessionId id() {
        return this.castSessionInfo.getId();
    }

    @Override
    public MediaReceiver mediaReceiver() {
        this.checkNotClosed();
        if (this.receiver != null) {
            return this.receiver;
        }
        return this.profile.mediaCasting().mediaReceivers().await(mediaReceiver -> {
            MediaReceiverId id = ((MediaReceiverImpl)mediaReceiver).id();
            return id.equals(this.castSessionInfo.getReceiverId());
        });
    }

    @Override
    public CastMode mode() {
        this.checkNotClosed();
        return this.castSessionInfo.getMode().toPublic();
    }

    @Override
    public String description() {
        this.checkNotClosed();
        return ((StringValue)this.rpc.invoke(this.rpc.stub()::getDescription, this.sessionsDetailsRequest())).getValue();
    }

    @Override
    public void stop() {
        this.checkNotClosed();
        StopCastSessionRequest request = StopCastSessionRequest.newBuilder().setProfileId(this.profile.id()).setSessionId(this.castSessionInfo.getId()).build();
        this.rpc.invoke(this.rpc.stub()::stop, request);
    }

    @Override
    public boolean isAlive() {
        this.checkNotClosed();
        return ((BoolValue)this.rpc.invoke(this.rpc.stub()::isAlive, this.sessionsDetailsRequest())).getValue();
    }

    @Override
    public boolean isLocal() {
        this.checkNotClosed();
        return this.castSessionInfo.getIsLocal();
    }

    @Override
    public Profile profile() {
        return this.profile;
    }

    private CastSessionDetailsRequest sessionsDetailsRequest() {
        return CastSessionDetailsRequest.newBuilder().setProfileId(this.profile.id()).setSessionId(this.castSessionInfo.getId()).build();
    }

    @Override
    public <E extends com.teamdev.jxbrowser.cast.event.CastSessionStopped> Subscription on(Class<E> eventClass, Observer<E> observer) {
        return this.rpc.on(eventClass, observer);
    }
}

