/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.cast.internal;

import com.teamdev.jxbrowser.cast.CastSession;
import com.teamdev.jxbrowser.cast.CastSessions;
import com.teamdev.jxbrowser.cast.event.CastSessionsEvent;
import com.teamdev.jxbrowser.cast.internal.CastSessionImpl;
import com.teamdev.jxbrowser.cast.internal.rpc.CastSessionDiscovered;
import com.teamdev.jxbrowser.cast.internal.rpc.CastSessionInfo;
import com.teamdev.jxbrowser.cast.internal.rpc.CastSessionList;
import com.teamdev.jxbrowser.cast.internal.rpc.CastSessionsStub;
import com.teamdev.jxbrowser.event.Observer;
import com.teamdev.jxbrowser.event.Subscription;
import com.teamdev.jxbrowser.internal.CloseableImpl;
import com.teamdev.jxbrowser.internal.IdMap;
import com.teamdev.jxbrowser.internal.Preconditions;
import com.teamdev.jxbrowser.internal.rpc.CastSessionId;
import com.teamdev.jxbrowser.internal.rpc.ServiceConnectionImpl;
import com.teamdev.jxbrowser.internal.rpc.stream.Interceptor;
import com.teamdev.jxbrowser.profile.Profile;
import com.teamdev.jxbrowser.profile.internal.ProfileImpl;
import java.util.List;
import java.util.Optional;

public final class CastSessionsImpl
extends CloseableImpl
implements CastSessions {
    private final IdMap<CastSessionId, CastSessionImpl> castSessions;
    private final ProfileImpl profile;
    private final ServiceConnectionImpl<CastSessionsStub> rpc;

    CastSessionsImpl(ProfileImpl profile) {
        Preconditions.checkNotNull(profile);
        this.profile = profile;
        this.castSessions = new IdMap();
        this.rpc = new ServiceConnectionImpl<CastSessionsStub>(profile.id(), profile.engine().connection(), CastSessionsStub::new);
    }

    void startObserving() {
        this.initialSessions().forEach(castSession -> this.castSessions.put(castSession.id(), (CastSessionImpl)castSession));
        this.rpc.setEventInterceptor(CastSessionDiscovered.class, event -> {
            CastSessionImpl castSession = new CastSessionImpl(event.getSession(), this.profile);
            this.castSessions.putIfAbsent(event.getSession().getId(), castSession);
            return Interceptor.Action.PROCEED;
        });
    }

    private List<CastSessionImpl> initialSessions() {
        this.checkNotClosed();
        return ((CastSessionList)this.rpc.invoke(this.rpc.stub()::getCastSessions, this.profile.id())).getSessionList().stream().map(castSessionInfo -> new CastSessionImpl((CastSessionInfo)castSessionInfo, this.profile)).toList();
    }

    @Override
    public Profile profile() {
        return this.profile;
    }

    @Override
    public List<CastSession> list() {
        this.checkNotClosed();
        return List.copyOf(this.castSessions.values());
    }

    public Optional<CastSessionImpl> byId(CastSessionId sessionId) {
        return this.castSessions.find(sessionId);
    }

    void removeCastSession(CastSessionId sessionId) {
        this.castSessions.remove(sessionId);
    }

    @Override
    public void close() {
        this.castSessions.values().forEach(CloseableImpl::close);
        super.close();
    }

    @Override
    public <E extends CastSessionsEvent> Subscription on(Class<E> eventClass, Observer<E> observer) {
        return this.rpc.on(eventClass, observer);
    }
}

