/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.cast.internal;

import com.teamdev.jxbrowser.cast.Screen;
import com.teamdev.jxbrowser.cast.Screens;
import com.teamdev.jxbrowser.cast.internal.rpc.MediaScreenList;
import com.teamdev.jxbrowser.cast.internal.rpc.ScreensStub;
import com.teamdev.jxbrowser.internal.CloseableImpl;
import com.teamdev.jxbrowser.internal.Preconditions;
import com.teamdev.jxbrowser.internal.rpc.Protobuf;
import com.teamdev.jxbrowser.internal.rpc.ServiceConnectionImpl;
import com.teamdev.jxbrowser.profile.Profile;
import com.teamdev.jxbrowser.profile.internal.ProfileImpl;
import java.util.List;

public class ScreensImpl
extends CloseableImpl
implements Screens {
    private final ServiceConnectionImpl<ScreensStub> rpc;
    private final ProfileImpl profile;

    ScreensImpl(ProfileImpl profile) {
        Preconditions.checkNotNull(profile);
        this.profile = profile;
        this.rpc = new ServiceConnectionImpl<ScreensStub>(profile.id(), profile.engine().connection(), ScreensStub::new);
    }

    @Override
    public Profile profile() {
        return this.profile;
    }

    @Override
    public List<Screen> list() {
        this.checkNotClosed();
        return List.copyOf(((MediaScreenList)this.rpc.invoke(this.rpc.stub()::getScreenSources, Protobuf.empty())).getScreenList());
    }

    @Override
    public Screen defaultScreen() {
        List<Screen> screens = this.list();
        Preconditions.checkState(screens.size() >= 1, "There should be at least one connected screen.", new Object[0]);
        return screens.get(0);
    }
}

