/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.cookie.internal;

import com.teamdev.jxbrowser.cookie.Cookie;
import com.teamdev.jxbrowser.cookie.CookieStore;
import com.teamdev.jxbrowser.cookie.internal.rpc.CookieExclusionReason;
import com.teamdev.jxbrowser.cookie.internal.rpc.CookieList;
import com.teamdev.jxbrowser.cookie.internal.rpc.CookieStoreStub;
import com.teamdev.jxbrowser.cookie.internal.rpc.DeleteCookieRequest;
import com.teamdev.jxbrowser.cookie.internal.rpc.GetCookiesForUrlRequest;
import com.teamdev.jxbrowser.cookie.internal.rpc.SetCookieError;
import com.teamdev.jxbrowser.cookie.internal.rpc.SetCookieRequest;
import com.teamdev.jxbrowser.cookie.internal.rpc.SetCookieResult;
import com.teamdev.jxbrowser.deps.com.google.protobuf.Int32Value;
import com.teamdev.jxbrowser.deps.com.google.protobuf.StringValue;
import com.teamdev.jxbrowser.engine.internal.EngineImpl;
import com.teamdev.jxbrowser.internal.CloseableImpl;
import com.teamdev.jxbrowser.internal.Preconditions;
import com.teamdev.jxbrowser.internal.Wrappers;
import com.teamdev.jxbrowser.internal.rpc.ServiceConnectionImpl;
import com.teamdev.jxbrowser.internal.string.StringPreconditions;
import com.teamdev.jxbrowser.profile.internal.ProfileImpl;
import com.teamdev.jxbrowser.time.TimeRange;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public final class CookieStoreImpl
extends CloseableImpl
implements CookieStore {
    private final ProfileImpl profile;
    private final ServiceConnectionImpl<CookieStoreStub> rpc;

    public CookieStoreImpl(ProfileImpl profile) {
        Preconditions.checkNotNull(profile);
        this.profile = profile;
        EngineImpl engine = profile.engine();
        this.rpc = new ServiceConnectionImpl<CookieStoreStub>(engine.id(), engine.connection(), CookieStoreStub::new);
    }

    @Override
    public ProfileImpl profile() {
        return this.profile;
    }

    @Override
    public List<Cookie> cookies() {
        this.checkNotClosed();
        return Collections.unmodifiableList(((CookieList)this.rpc.invoke(this.rpc.stub()::getAllCookies, this.profile.id())).getCookieList());
    }

    @Override
    public List<Cookie> cookies(String url) {
        StringPreconditions.checkNotNullEmptyOrBlank(url);
        this.checkNotClosed();
        GetCookiesForUrlRequest request = GetCookiesForUrlRequest.newBuilder().setUrl(StringValue.of(url)).setProfileId(this.profile.id()).build();
        return Collections.unmodifiableList(((CookieList)this.rpc.invoke(this.rpc.stub()::getCookiesForUrl, request)).getCookieList());
    }

    @Override
    public void delete(Cookie cookie) {
        Preconditions.checkNotNull(cookie);
        this.checkNotClosed();
        DeleteCookieRequest request = DeleteCookieRequest.newBuilder().setCookie(CookieStoreImpl.unwrapCookie(cookie)).setProfileId(this.profile.id()).build();
        this.rpc.invoke(this.rpc.stub()::deleteCookie, request);
    }

    private static com.teamdev.jxbrowser.cookie.internal.rpc.Cookie unwrapCookie(Cookie cookie) {
        return Wrappers.unwrap(cookie, com.teamdev.jxbrowser.cookie.internal.rpc.Cookie.class);
    }

    @Override
    public int deleteAll() {
        return this.deleteAll(TimeRange.FULL);
    }

    @Override
    public int deleteAll(TimeRange range) {
        this.checkNotClosed();
        return ((Int32Value)this.rpc.invoke(this.rpc.stub()::deleteAllCookies, this.profile.clearProfileDataRequest(range))).getValue();
    }

    @Override
    public void set(Cookie cookie) {
        this.checkNotClosed();
        Preconditions.checkNotNull(cookie);
        SetCookieRequest request = SetCookieRequest.newBuilder().setProfileId(this.profile.id()).setCookie(CookieStoreImpl.unwrapCookie(cookie)).build();
        SetCookieResult result = (SetCookieResult)this.rpc.invoke(this.rpc.stub()::setCookie, request);
        if (result.getValueCase() == SetCookieResult.ValueCase.ERROR) {
            throw new IllegalArgumentException(this.errorMessage(result.getError()));
        }
    }

    @Override
    public void persist() {
        this.checkNotClosed();
        this.rpc.invoke(this.rpc.stub()::save, this.profile.id());
    }

    private String errorMessage(SetCookieError cookie) {
        List messages = cookie.getReasonList().stream().map(this::reasonToString).collect(Collectors.toList());
        return String.join((CharSequence)" ", messages);
    }

    private String reasonToString(CookieExclusionReason reason) {
        String error = "The error is not specified.";
        switch (reason) {
            case SAMESITE_NONE_INSECURE: {
                error = "The SameSite attribute is None, but the cookie is not secure.";
                break;
            }
            case OVERWRITE_SECURE: {
                error = "The non-secure cookie overwrites an equivalent secure cookie.";
                break;
            }
            case INVALID_DOMAIN: {
                error = "The domain is invalid.";
                break;
            }
            case EXCLUSION_REASON_UNKNOWN: {
                error = "The unknown error.";
                break;
            }
        }
        return error;
    }
}

