/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.engine;

import com.teamdev.jxbrowser.annotation.Immutable;
import com.teamdev.jxbrowser.engine.Language;
import com.teamdev.jxbrowser.engine.PasswordStore;
import com.teamdev.jxbrowser.engine.ProprietaryFeature;
import com.teamdev.jxbrowser.engine.RenderingMode;
import com.teamdev.jxbrowser.engine.internal.EngineImpl;
import com.teamdev.jxbrowser.internal.Preconditions;
import com.teamdev.jxbrowser.internal.string.StringPreconditions;
import com.teamdev.jxbrowser.net.Scheme;
import com.teamdev.jxbrowser.net.callback.InterceptUrlRequestCallback;
import com.teamdev.jxbrowser.net.internal.NonInterceptableScheme;
import com.teamdev.jxbrowser.os.Environment;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;

@Immutable
public final class EngineOptions {
    private final Path userDataDir;
    private final Path chromiumDir;
    private final String licenseKey;
    private final String userAgent;
    private final String googleApiKey;
    private final String googleDefaultClientId;
    private final String googleDefaultClientSecret;
    private final Long diskCacheSize;
    private final Integer remoteDebuggingPort;
    private final Duration rendererHangTimeout;
    private final boolean incognitoEnabled;
    private final boolean mediaRoutingEnabled;
    private final boolean sandboxDisabled;
    private final boolean webSecurityDisabled;
    private final boolean dnsOverHttpsDisabled;
    private final boolean fileAccessFromFilesAllowed;
    private final boolean autoplayEnabled;
    private final boolean gpuDisabled;
    private final Language language;
    private final RenderingMode renderingMode;
    private final PasswordStore passwordStore;
    private final List<String> switches;
    private final List<String> secureOriginWhiteList;
    private final boolean touchMenuDisabled;
    private final boolean dnsQuickCheckDisabled;
    private final ZoneId timeZone;
    private final Set<ProprietaryFeature> proprietaryFeatures;
    private final Map<Scheme, InterceptUrlRequestCallback> schemes;

    public static Builder newBuilder(RenderingMode renderingMode) {
        Preconditions.checkNotNull(renderingMode);
        return new Builder(renderingMode);
    }

    private EngineOptions(Builder builder) {
        this.userDataDir = builder.userDataDir;
        this.chromiumDir = builder.chromiumDir;
        this.licenseKey = builder.licenseKey;
        this.userAgent = builder.userAgent;
        this.googleApiKey = builder.googleApiKey;
        this.googleDefaultClientId = builder.googleDefaultClientId;
        this.googleDefaultClientSecret = builder.googleDefaultClientSecret;
        this.diskCacheSize = builder.diskCacheSize;
        this.remoteDebuggingPort = builder.remoteDebuggingPort;
        this.rendererHangTimeout = builder.rendererHangTimeout;
        this.incognitoEnabled = builder.incognitoEnabled;
        this.mediaRoutingEnabled = builder.mediaRoutingEnabled;
        this.sandboxDisabled = builder.sandboxDisabled;
        this.webSecurityDisabled = builder.webSecurityDisabled;
        this.dnsOverHttpsDisabled = builder.dnsOverHttpsDisabled;
        this.fileAccessFromFilesAllowed = builder.fileAccessFromFilesAllowed;
        this.autoplayEnabled = builder.autoplayEnabled;
        this.gpuDisabled = builder.gpuDisabled;
        this.dnsQuickCheckDisabled = builder.dnsQuickCheckDisabled;
        this.timeZone = builder.timeZone;
        this.language = builder.language;
        this.renderingMode = builder.renderingMode;
        this.passwordStore = builder.passwordStore;
        this.switches = builder.buildSwitches();
        this.secureOriginWhiteList = builder.secureOriginWhiteList;
        this.touchMenuDisabled = builder.touchMenuDisabled;
        this.proprietaryFeatures = builder.buildProprietaryFeatures();
        this.schemes = Map.copyOf(builder.schemes);
    }

    public Path userDataDir() {
        return this.userDataDir;
    }

    public Path chromiumDir() {
        return this.chromiumDir;
    }

    public Optional<String> licenseKey() {
        return Optional.ofNullable(this.licenseKey);
    }

    public Optional<String> userAgent() {
        return Optional.ofNullable(this.userAgent);
    }

    public Optional<String> googleApiKey() {
        return Optional.ofNullable(this.googleApiKey);
    }

    public Optional<String> googleDefaultClientId() {
        return Optional.ofNullable(this.googleDefaultClientId);
    }

    public Optional<String> googleDefaultClientSecret() {
        return Optional.ofNullable(this.googleDefaultClientSecret);
    }

    public RenderingMode renderingMode() {
        return this.renderingMode;
    }

    public Language language() {
        return this.language;
    }

    public Optional<Integer> remoteDebuggingPort() {
        return Optional.ofNullable(this.remoteDebuggingPort);
    }

    public Duration rendererHangTimeout() {
        return this.rendererHangTimeout;
    }

    public Optional<PasswordStore> passwordStore() {
        return Optional.ofNullable(this.passwordStore);
    }

    public Optional<Long> diskCacheSize() {
        return Optional.ofNullable(this.diskCacheSize);
    }

    public boolean isIncognitoEnabled() {
        return this.incognitoEnabled;
    }

    public boolean isMediaRoutingEnabled() {
        return this.mediaRoutingEnabled;
    }

    public boolean isSandboxDisabled() {
        return this.sandboxDisabled;
    }

    public boolean isWebSecurityDisabled() {
        return this.webSecurityDisabled;
    }

    public boolean isDnsOverHttpsDisabled() {
        return this.dnsOverHttpsDisabled;
    }

    public boolean isFileAccessFromFilesAllowed() {
        return this.fileAccessFromFilesAllowed;
    }

    public boolean isAutoplayEnabled() {
        return this.autoplayEnabled;
    }

    public boolean isGpuDisabled() {
        return this.gpuDisabled;
    }

    public boolean isDnsQuickCheckDisabled() {
        return this.dnsQuickCheckDisabled;
    }

    public Optional<ZoneId> timeZone() {
        return Optional.ofNullable(this.timeZone);
    }

    public boolean isTouchMenuDisabled() {
        return this.touchMenuDisabled;
    }

    public boolean isProprietaryFeatureEnabled(ProprietaryFeature feature) {
        return this.proprietaryFeatures.contains((Object)feature);
    }

    @Immutable
    public Set<ProprietaryFeature> proprietaryFeatures() {
        return this.proprietaryFeatures;
    }

    @Immutable
    public List<String> secureOriginWhiteList() {
        return this.secureOriginWhiteList;
    }

    @Immutable
    public List<String> switches() {
        return this.switches;
    }

    @Immutable
    public Map<Scheme, InterceptUrlRequestCallback> schemes() {
        return this.schemes;
    }

    private static String nonInterceptableSchemeErrorMessage(Scheme scheme) {
        return String.format("The '%s' scheme cannot be intercepted. The list of schemes that cannot be intercepted: %s", scheme.name(), NonInterceptableScheme.stringRepresentation());
    }

    public static final class Builder {
        private static final Duration CHROMIUM_DEFAULT_HANG_TIMEOUT = Duration.ofSeconds(15L);
        private final RenderingMode renderingMode;
        private final List<String> switches;
        private final EnumSet<ProprietaryFeature> proprietaryFeatures;
        private final Map<Scheme, InterceptUrlRequestCallback> schemes;
        private List<String> secureOriginWhiteList;
        private Path userDataDir;
        private Path chromiumDir;
        private String licenseKey;
        private String userAgent;
        private String googleApiKey;
        private String googleDefaultClientId;
        private String googleDefaultClientSecret;
        private Long diskCacheSize;
        private boolean gpuDisabled;
        private boolean incognitoEnabled;
        private boolean mediaRoutingEnabled;
        private boolean sandboxDisabled;
        private boolean webSecurityDisabled;
        private boolean dnsOverHttpsDisabled;
        private boolean fileAccessFromFilesAllowed;
        private boolean autoplayEnabled;
        private Language language;
        private PasswordStore passwordStore;
        private Integer remoteDebuggingPort;
        private Duration rendererHangTimeout;
        private boolean touchMenuDisabled;
        private boolean dnsQuickCheckDisabled;
        private ZoneId timeZone;

        private Builder(RenderingMode renderingMode) {
            this.renderingMode = renderingMode;
            this.chromiumDir = Paths.get(System.getProperty("jxbrowser.chromium.dir", Environment.defaultChromiumDir().toString()), new String[0]);
            this.userDataDir = EngineImpl.tempUserDataDirs.add(Environment.userTempDir().resolve("JxBrowser-UserData-" + String.valueOf(UUID.randomUUID())));
            this.language = Language.of(Locale.getDefault()).orElse(Language.ENGLISH_US);
            this.switches = new ArrayList<String>();
            this.secureOriginWhiteList = List.of();
            this.proprietaryFeatures = EnumSet.noneOf(ProprietaryFeature.class);
            this.schemes = new HashMap<Scheme, InterceptUrlRequestCallback>();
            this.rendererHangTimeout = CHROMIUM_DEFAULT_HANG_TIMEOUT;
        }

        public Builder userDataDir(Path userDataDir) {
            Preconditions.checkNotNull(userDataDir);
            this.userDataDir = userDataDir;
            return this;
        }

        public Builder chromiumDir(Path chromiumDir) {
            Preconditions.checkNotNull(chromiumDir);
            this.chromiumDir = chromiumDir;
            return this;
        }

        public Builder licenseKey(String licenseKey) {
            StringPreconditions.checkNotNullEmptyOrBlank(licenseKey);
            this.licenseKey = licenseKey;
            return this;
        }

        public Builder userAgent(String userAgent) {
            StringPreconditions.checkNotNullEmptyOrBlank(userAgent);
            this.userAgent = userAgent;
            return this;
        }

        public Builder googleApiKey(String googleApiKey) {
            StringPreconditions.checkNotNullEmptyOrBlank(googleApiKey);
            this.googleApiKey = googleApiKey;
            return this;
        }

        public Builder googleDefaultClientId(String googleDefaultClientId) {
            StringPreconditions.checkNotNullEmptyOrBlank(googleDefaultClientId);
            this.googleDefaultClientId = googleDefaultClientId;
            return this;
        }

        public Builder googleDefaultClientSecret(String googleDefaultClientSecret) {
            StringPreconditions.checkNotNullEmptyOrBlank(googleDefaultClientSecret);
            this.googleDefaultClientSecret = googleDefaultClientSecret;
            return this;
        }

        public Builder language(Language language) {
            Preconditions.checkNotNull(language);
            this.language = language;
            return this;
        }

        public Builder remoteDebuggingPort(int remoteDebuggingPort) {
            Preconditions.checkArgument(remoteDebuggingPort > 0);
            this.remoteDebuggingPort = remoteDebuggingPort;
            return this;
        }

        public Builder rendererHangTimeout(Duration timeout) {
            Preconditions.checkNotNull(timeout);
            this.rendererHangTimeout = timeout;
            return this;
        }

        public Builder passwordStore(PasswordStore passwordStore) {
            Preconditions.checkNotNull(passwordStore);
            this.passwordStore = passwordStore;
            return this;
        }

        public Builder diskCacheSize(long diskCacheSize) {
            Preconditions.checkArgument(diskCacheSize > 0L);
            this.diskCacheSize = diskCacheSize;
            return this;
        }

        public Builder disableTouchMenu() {
            this.touchMenuDisabled = true;
            return this;
        }

        public Builder disableDnsQuickCheck() {
            this.dnsQuickCheckDisabled = true;
            return this;
        }

        public Builder timeZone(ZoneId zoneId) {
            Preconditions.checkNotNull(zoneId);
            this.timeZone = zoneId;
            return this;
        }

        public Builder enableIncognito() {
            this.incognitoEnabled = true;
            return this;
        }

        public Builder enableMediaRouting() {
            this.mediaRoutingEnabled = true;
            return this;
        }

        public Builder disableSandbox() {
            this.sandboxDisabled = true;
            return this;
        }

        public Builder disableWebSecurity() {
            this.webSecurityDisabled = true;
            return this;
        }

        public Builder allowFileAccessFromFiles() {
            this.fileAccessFromFilesAllowed = true;
            return this;
        }

        public Builder enableAutoplay() {
            this.autoplayEnabled = true;
            return this;
        }

        public Builder disableGpu() {
            this.gpuDisabled = true;
            return this;
        }

        public Builder treatInsecureOriginAsSecure(String ... origins) {
            Preconditions.checkNotNull(origins);
            this.secureOriginWhiteList = List.of(origins);
            return this;
        }

        public Builder addSwitch(String commandLineSwitch) {
            StringPreconditions.checkNotNullEmptyOrBlank(commandLineSwitch);
            this.switches.add(commandLineSwitch);
            return this;
        }

        public Builder enableProprietaryFeature(ProprietaryFeature feature) {
            Preconditions.checkNotNull(feature);
            this.proprietaryFeatures.add(feature);
            return this;
        }

        public Builder disableDnsOverHttps() {
            this.dnsOverHttpsDisabled = true;
            return this;
        }

        public Builder addScheme(Scheme scheme, InterceptUrlRequestCallback callback) {
            Preconditions.checkNotNull(scheme);
            Preconditions.checkNotNull(callback);
            Preconditions.checkArgument(!NonInterceptableScheme.contains(scheme), EngineOptions.nonInterceptableSchemeErrorMessage(scheme), new Object[0]);
            this.schemes.put(scheme, callback);
            return this;
        }

        public EngineOptions build() {
            return new EngineOptions(this);
        }

        private List<String> buildSwitches() {
            return List.copyOf(this.switches);
        }

        private Set<ProprietaryFeature> buildProprietaryFeatures() {
            return EnumSet.copyOf(this.proprietaryFeatures);
        }
    }
}

