/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.engine.internal;

import com.teamdev.jxbrowser.VersionInfo;
import com.teamdev.jxbrowser.browser.Browser;
import com.teamdev.jxbrowser.browser.internal.RenderProcesses;
import com.teamdev.jxbrowser.cache.HttpAuthCache;
import com.teamdev.jxbrowser.cache.HttpCache;
import com.teamdev.jxbrowser.cookie.CookieStore;
import com.teamdev.jxbrowser.deps.com.google.protobuf.Empty;
import com.teamdev.jxbrowser.download.Downloads;
import com.teamdev.jxbrowser.engine.ChromiumBinaries;
import com.teamdev.jxbrowser.engine.ChromiumProcessStartupFailureException;
import com.teamdev.jxbrowser.engine.Engine;
import com.teamdev.jxbrowser.engine.EngineInitializationException;
import com.teamdev.jxbrowser.engine.EngineOptions;
import com.teamdev.jxbrowser.engine.IpcSetupFailureException;
import com.teamdev.jxbrowser.engine.SandboxNotSupportedException;
import com.teamdev.jxbrowser.engine.Theme;
import com.teamdev.jxbrowser.engine.UserDataDirectoryAlreadyInUseException;
import com.teamdev.jxbrowser.engine.UserDataDirectoryCreationException;
import com.teamdev.jxbrowser.engine.Widevine;
import com.teamdev.jxbrowser.engine.event.EngineClosed;
import com.teamdev.jxbrowser.engine.event.EngineCrashed;
import com.teamdev.jxbrowser.engine.event.EngineEvent;
import com.teamdev.jxbrowser.engine.event.internal.EngineClosedImpl;
import com.teamdev.jxbrowser.engine.event.internal.EngineCrashedImpl;
import com.teamdev.jxbrowser.engine.internal.ClassPreLoader;
import com.teamdev.jxbrowser.engine.internal.LicenseExceptionFactory;
import com.teamdev.jxbrowser.engine.internal.LinuxDependencies;
import com.teamdev.jxbrowser.engine.internal.StackTrace;
import com.teamdev.jxbrowser.engine.internal.TempUserDataDirs;
import com.teamdev.jxbrowser.engine.internal.WidevineImpl;
import com.teamdev.jxbrowser.event.Observer;
import com.teamdev.jxbrowser.event.Subscription;
import com.teamdev.jxbrowser.event.internal.ObservableHelper;
import com.teamdev.jxbrowser.internal.ChromiumBundleMac;
import com.teamdev.jxbrowser.internal.ChromiumProcess;
import com.teamdev.jxbrowser.internal.CloseableImpl;
import com.teamdev.jxbrowser.internal.Files;
import com.teamdev.jxbrowser.internal.IdMap;
import com.teamdev.jxbrowser.internal.JniLibrary;
import com.teamdev.jxbrowser.internal.Lazy;
import com.teamdev.jxbrowser.internal.Preconditions;
import com.teamdev.jxbrowser.internal.UnsupportedSystemProperties;
import com.teamdev.jxbrowser.internal.event.ChromiumProcessStartFailed;
import com.teamdev.jxbrowser.internal.event.ChromiumProcessTerminated;
import com.teamdev.jxbrowser.internal.licensing.License;
import com.teamdev.jxbrowser.internal.licensing.LicenseVerificationStatus;
import com.teamdev.jxbrowser.internal.memory.SharedMemoryManager;
import com.teamdev.jxbrowser.internal.platform.mac.MachService;
import com.teamdev.jxbrowser.internal.rpc.ApplyLicenseResponse;
import com.teamdev.jxbrowser.internal.rpc.ConnectionId;
import com.teamdev.jxbrowser.internal.rpc.ConnectionType;
import com.teamdev.jxbrowser.internal.rpc.EngineFactoryStub;
import com.teamdev.jxbrowser.internal.rpc.EngineId;
import com.teamdev.jxbrowser.internal.rpc.EngineStub;
import com.teamdev.jxbrowser.internal.rpc.ExitCode;
import com.teamdev.jxbrowser.internal.rpc.Protobuf;
import com.teamdev.jxbrowser.internal.rpc.ServiceConnectionImpl;
import com.teamdev.jxbrowser.internal.rpc.event.ConnectionCreated;
import com.teamdev.jxbrowser.internal.rpc.transport.Connection;
import com.teamdev.jxbrowser.internal.rpc.transport.ConnectionServer;
import com.teamdev.jxbrowser.logging.Logger;
import com.teamdev.jxbrowser.media.MediaDevices;
import com.teamdev.jxbrowser.media.internal.MediaDevicesImpl;
import com.teamdev.jxbrowser.net.Network;
import com.teamdev.jxbrowser.net.proxy.Proxy;
import com.teamdev.jxbrowser.os.Environment;
import com.teamdev.jxbrowser.permission.Permissions;
import com.teamdev.jxbrowser.plugin.Plugins;
import com.teamdev.jxbrowser.profile.internal.ProfilesImpl;
import com.teamdev.jxbrowser.spellcheck.SpellChecker;
import com.teamdev.jxbrowser.ui.internal.rpc.AppTheme;
import com.teamdev.jxbrowser.ui.internal.rpc.GetColorResponse;
import com.teamdev.jxbrowser.ui.internal.rpc.NativeThemeStub;
import com.teamdev.jxbrowser.ui.internal.rpc.SetThemeColorRequest;
import com.teamdev.jxbrowser.zoom.ZoomLevels;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public final class EngineImpl
extends CloseableImpl
implements Engine {
    private static final String USER_NAMESPACES_NOT_SUPPORTED_MESSAGE = "The current environment does not support creating processes within a new user namespace. As a result, Chromium cannot be launched in sandbox mode. See: https://teamdev.com/jxbrowser/docs/guides/chromium/#sandbox";
    public static final TempUserDataDirs tempUserDataDirs = new TempUserDataDirs();
    private static final int IPC_SETUP_TIMEOUT_IN_SECONDS = 600;
    private static final IdMap<EngineId, EngineImpl> engineIdToEngineMap = new IdMap();
    private final EngineId id;
    private final EngineOptions options;
    private final ChromiumProcess chromiumProcess;
    private final RenderProcesses renderProcesses;
    private final Connection connection;
    private final Connection netConnection;
    private final ConnectionServer connectionServer;
    private final ServiceConnectionImpl<EngineStub> rpc;
    private final ServiceConnectionImpl<NativeThemeStub> nativeThemeRpc;
    private final Subscription chromiumProcessTerminated;
    private final ObservableHelper<EngineEvent> observable;
    private final ProfilesImpl profiles;
    private final WidevineImpl widevine;
    private final Lazy<MachService> machService;
    private final Lazy<MediaDevicesImpl> mediaDevices;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EngineImpl newInstance(EngineOptions options) {
        ChromiumProcessTerminated chromiumProcessTerminated;
        Preconditions.checkNotNull(options);
        UnsupportedSystemProperties.validateSystemProperties();
        Environment.checkEnvironment();
        Path chromiumDir = options.chromiumDir();
        if (Environment.isMac()) {
            JniLibrary.path(ChromiumBundleMac.librariesDir(chromiumDir));
        } else {
            JniLibrary.path(chromiumDir);
        }
        ChromiumBinaries.deliverTo(chromiumDir);
        if (Environment.isLinux()) {
            new LinuxDependencies(chromiumDir).checkAvailability();
        }
        Path userDataDir = options.userDataDir();
        ConnectionServer connectionServer = new ConnectionServer();
        CountDownLatch latch = new CountDownLatch(1);
        AtomicReference connectionIdRef = new AtomicReference();
        Subscription connectionCreated = connectionServer.on(ConnectionCreated.class, event -> {
            if (event.connection().type().equals(ConnectionType.BROWSER)) {
                connectionIdRef.set(event.connection().id());
                latch.countDown();
            }
        });
        ChromiumProcess chromiumProcess = ChromiumProcess.create(connectionServer.port(), chromiumDir);
        AtomicReference chromiumProcessStartFailedRef = new AtomicReference();
        AtomicReference chromiumProcessTerminatedRef = new AtomicReference();
        chromiumProcess.on(ChromiumProcessStartFailed.class, event -> {
            chromiumProcessStartFailedRef.set(event);
            latch.countDown();
        });
        chromiumProcess.on(ChromiumProcessTerminated.class, event -> {
            chromiumProcessTerminatedRef.set(event);
            latch.countDown();
        });
        try {
            chromiumProcess.start(options);
        }
        catch (ChromiumProcessStartupFailureException e) {
            EngineImpl.throwExceptionAndCleanup(userDataDir, connectionServer, e);
        }
        try {
            if (!latch.await(600L, TimeUnit.SECONDS)) {
                EngineImpl.throwExceptionAndCleanup(userDataDir, connectionServer, new IpcSetupFailureException());
            }
        }
        catch (InterruptedException e) {
            EngineImpl.throwExceptionAndCleanup(userDataDir, connectionServer, new IpcSetupFailureException("The current thread has been interrupted.", e));
        }
        finally {
            connectionCreated.unsubscribe();
        }
        if (chromiumProcessStartFailedRef.get() != null) {
            EngineImpl.throwExceptionAndCleanup(userDataDir, connectionServer, new ChromiumProcessStartupFailureException());
        }
        if ((chromiumProcessTerminated = (ChromiumProcessTerminated)chromiumProcessTerminatedRef.get()) != null) {
            int exitCode = chromiumProcess.exitCode();
            if (exitCode == ExitCode.USER_DATA_IN_USE.getNumber()) {
                EngineImpl.throwException(connectionServer, new UserDataDirectoryAlreadyInUseException(userDataDir));
            } else if (exitCode == ExitCode.SANDBOX_NOT_SUPPORTED.getNumber()) {
                EngineImpl.throwExceptionAndCleanup(userDataDir, connectionServer, new SandboxNotSupportedException(USER_NAMESPACES_NOT_SUPPORTED_MESSAGE));
            } else {
                EngineImpl.throwExceptionAndCleanup(userDataDir, connectionServer, new ChromiumProcessStartupFailureException(exitCode));
            }
        }
        Optional<Object> connection = Optional.empty();
        try {
            connection = connectionServer.awaitConnection((ConnectionId)connectionIdRef.get());
            if (connection.isEmpty()) {
                EngineImpl.throwExceptionAndCleanup(userDataDir, connectionServer, new IpcSetupFailureException());
            }
        }
        catch (IllegalStateException e) {
            EngineImpl.throwExceptionAndCleanup(userDataDir, connectionServer, new IpcSetupFailureException());
        }
        ServiceConnectionImpl<EngineFactoryStub> rpc = new ServiceConnectionImpl<EngineFactoryStub>(Protobuf.empty(), (Connection)connection.get(), EngineFactoryStub::new);
        EngineId engineId = EngineId.getDefaultInstance();
        try {
            List<StackTraceElement> stackTraceElements = List.of(Thread.currentThread().getStackTrace());
            StackTrace stackTrace = new StackTrace(stackTraceElements);
            Logger.debug(() -> "Product binding call stack:" + System.lineSeparator() + String.valueOf(stackTrace));
            License license = License.newBuilder().setProductName("JxBrowser").setProductVersion(VersionInfo.version()).setStackTrace(stackTrace.toString()).setKey(EngineImpl.licenseKey(options)).build();
            LicenseVerificationStatus status = ((ApplyLicenseResponse)rpc.invoke(rpc.stub()::applyLicense, license)).getStatus();
            if (status == LicenseVerificationStatus.VALID) {
                engineId = (EngineId)rpc.invoke(rpc.stub()::createEngine, Protobuf.empty());
            } else {
                rpc.invokeAsync(rpc.stub()::exit, Protobuf.empty());
                chromiumProcess.close();
                EngineImpl.throwExceptionAndCleanup(userDataDir, connectionServer, LicenseExceptionFactory.create(status));
            }
        }
        catch (IllegalStateException e) {
            Logger.debug("The connection has been terminated.");
            chromiumProcess.terminate();
            int exitCode = chromiumProcess.exitCode();
            if (exitCode == ExitCode.USER_DATA_IN_USE.getNumber()) {
                EngineImpl.throwException(connectionServer, new UserDataDirectoryAlreadyInUseException(userDataDir));
            }
            if (exitCode == ExitCode.USER_DATA_CREATION_ERROR.getNumber()) {
                EngineImpl.throwException(connectionServer, new UserDataDirectoryCreationException(userDataDir));
            }
            EngineImpl.throwExceptionAndCleanup(userDataDir, connectionServer, new ChromiumProcessStartupFailureException(exitCode));
        }
        EngineImpl engine = new EngineImpl((Connection)connection.get(), connectionServer, engineId, options, chromiumProcess);
        engine.on(EngineClosed.class, event -> EngineImpl.cleanUserDataDir(event.engine().options().userDataDir()));
        engine.on(EngineCrashed.class, event -> EngineImpl.cleanUserDataDir(event.engine().options().userDataDir()));
        return engine;
    }

    private EngineImpl(Connection connection, ConnectionServer connectionServer, EngineId engineId, EngineOptions options, ChromiumProcess chromiumProcess) {
        Preconditions.checkNotNull(connection);
        Preconditions.checkNotNull(connectionServer);
        Preconditions.checkNotNull(engineId);
        Preconditions.checkNotNull(options);
        Preconditions.checkNotNull(chromiumProcess);
        this.id = engineId;
        this.options = options;
        this.connection = connection;
        this.chromiumProcess = chromiumProcess;
        this.connectionServer = connectionServer;
        this.netConnection = this.isInProcessNetwork() ? connection : this.getNetworkConnection();
        this.renderProcesses = new RenderProcesses();
        this.observable = new ObservableHelper();
        this.profiles = new ProfilesImpl(this);
        this.widevine = new WidevineImpl(this);
        this.mediaDevices = new Lazy<MediaDevicesImpl>(() -> new MediaDevicesImpl(this));
        this.machService = new Lazy<MachService>(() -> new MachService(this));
        if (Environment.isMac()) {
            this.machService.get().start();
        }
        SharedMemoryManager.newInstance(this);
        this.rpc = new ServiceConnectionImpl<EngineStub>(this.id, connection, EngineStub::new);
        this.nativeThemeRpc = new ServiceConnectionImpl<NativeThemeStub>(this.id, connection, NativeThemeStub::new);
        this.chromiumProcessTerminated = chromiumProcess.on(ChromiumProcessTerminated.class, event -> new Thread(this::cleanup).start());
        engineIdToEngineMap.put(this.id, this);
    }

    private static void throwException(ConnectionServer connectionServer, EngineInitializationException exception) {
        connectionServer.close();
        throw exception;
    }

    private static void throwExceptionAndCleanup(Path userDataDir, ConnectionServer connectionServer, EngineInitializationException exception) {
        EngineImpl.cleanUserDataDir(userDataDir);
        EngineImpl.throwException(connectionServer, exception);
    }

    private static void cleanUserDataDir(Path userDataDir) {
        Preconditions.checkNotNull(userDataDir);
        if (tempUserDataDirs.list().contains(userDataDir)) {
            Files.deleteDir(tempUserDataDirs.remove(userDataDir));
        }
    }

    public Connection connection() {
        return this.connection;
    }

    public Connection netConnection() {
        return this.netConnection;
    }

    private boolean isInProcessNetwork() {
        return this.options.switches().stream().filter(s -> s.startsWith("--enable-features")).anyMatch(s -> s.contains("NetworkServiceInProcess"));
    }

    private Connection getNetworkConnection() {
        CompletableFuture networkConnection = new CompletableFuture();
        ConnectionServer connectionServer = this.connectionServer();
        Subscription subscription = connectionServer.on(ConnectionCreated.class, event -> {
            if (event.connection().type().equals(ConnectionType.NETWORK_SERVICE)) {
                networkConnection.complete(event.connection());
            }
        });
        connectionServer.getConnection(ConnectionType.NETWORK_SERVICE).ifPresent(networkConnection::complete);
        Connection network = (Connection)networkConnection.join();
        subscription.unsubscribe();
        return network;
    }

    public ConnectionServer connectionServer() {
        return this.connectionServer;
    }

    public RenderProcesses renderProcesses() {
        return this.renderProcesses;
    }

    public EngineId id() {
        return this.id;
    }

    @Override
    public EngineOptions options() {
        return this.options;
    }

    @Override
    public Browser newBrowser() {
        this.checkNotClosed();
        return this.profiles.defaultProfile().newBrowser();
    }

    @Override
    public List<Browser> browsers() {
        return this.profiles.defaultProfile().browsers();
    }

    @Override
    public ZoomLevels zoomLevels() {
        return this.profiles.defaultProfile().zoomLevels();
    }

    @Override
    public Proxy proxy() {
        return this.profiles.defaultProfile().proxy();
    }

    @Override
    public Network network() {
        return this.profiles.defaultProfile().network();
    }

    @Override
    public SpellChecker spellChecker() {
        return this.profiles.defaultProfile().spellChecker();
    }

    @Override
    public CookieStore cookieStore() {
        return this.profiles.defaultProfile().cookieStore();
    }

    @Override
    public HttpCache httpCache() {
        return this.profiles.defaultProfile().httpCache();
    }

    @Override
    public HttpAuthCache httpAuthCache() {
        return this.profiles.defaultProfile().httpAuthCache();
    }

    @Override
    public MediaDevices mediaDevices() {
        return this.mediaDevices.get();
    }

    @Override
    public Plugins plugins() {
        return this.profiles.defaultProfile().plugins();
    }

    @Override
    public Downloads downloads() {
        return this.profiles.defaultProfile().downloads();
    }

    @Override
    public Permissions permissions() {
        return this.profiles.defaultProfile().permissions();
    }

    @Override
    public ProfilesImpl profiles() {
        return this.profiles;
    }

    @Override
    public void setTheme(Theme theme) {
        Preconditions.checkNotNull(theme);
        this.checkNotClosed();
        AppTheme internalTheme = AppTheme.fromPublic(theme);
        SetThemeColorRequest request = SetThemeColorRequest.newBuilder().setEngineId(this.id).setTheme(internalTheme).build();
        this.nativeThemeRpc.invoke(this.nativeThemeRpc.stub()::setColorMode, request);
    }

    @Override
    public Theme theme() {
        this.checkNotClosed();
        AppTheme internalTheme = ((GetColorResponse)this.nativeThemeRpc.invoke(this.nativeThemeRpc.stub()::getColorMode, this.id)).getTheme();
        return internalTheme.toPublic();
    }

    @Override
    public Widevine widevine() {
        return this.widevine;
    }

    @Override
    public void close() {
        if (this.isClosed()) {
            return;
        }
        Logger.debug("Closing engine...");
        this.chromiumProcessTerminated.unsubscribe();
        this.widevine.close();
        this.profiles.close();
        if (!this.rpc.isClosed()) {
            this.rpc.invokeAsync(this.rpc.stub()::close, this.id);
        }
        this.cleanup();
        Logger.debug("Closing engine... [OK]");
    }

    private void cleanup() {
        Logger.debug("Cleanup...");
        this.renderProcesses.close();
        this.profiles.cleanup();
        EngineImpl.closeIfNecessary(this.mediaDevices);
        if (Environment.isMac()) {
            EngineImpl.closeIfNecessary(this.machService);
        }
        engineIdToEngineMap.remove(this.id);
        super.close();
        this.awaitProcessTermination();
        this.chromiumProcessTerminated.unsubscribe();
        this.connectionServer.close();
        Logger.debug("Cleanup... [OK]");
    }

    private void awaitProcessTermination() {
        Logger.debug("Awaiting process termination...");
        this.chromiumProcess.close();
        Logger.debug("Awaiting process termination... [OK]");
        int exitCode = this.chromiumProcess.exitCode();
        if (exitCode == ExitCode.OK.getNumber()) {
            Logger.debug("Chromium process exit code: {0}", exitCode);
            this.observable.notifyObservers(new EngineClosedImpl(this));
        } else {
            Logger.error("Chromium process exit code: {0}", exitCode);
            this.chromiumProcess.crashDumpDir().ifPresent(crashDumpDir -> Logger.error("Crash dump dir: {0}", crashDumpDir));
            this.observable.notifyObservers(new EngineCrashedImpl(this, exitCode));
        }
    }

    @Override
    public <E extends EngineEvent> Subscription on(Class<E> eventClass, Observer<E> listener) {
        return this.observable.on(eventClass, listener);
    }

    void crash() {
        this.checkNotClosed();
        this.rpc.invokeAsync(this.rpc.stub()::crash, Empty.getDefaultInstance());
    }

    private static String licenseKey(EngineOptions options) {
        boolean ambiguousLicense;
        String fromOpts = options.licenseKey().orElse("");
        String fromProps = Optional.ofNullable(System.getProperty("jxbrowser.license.key")).orElse("");
        boolean bl = ambiguousLicense = !fromOpts.isEmpty() && !fromProps.isEmpty();
        if (ambiguousLicense) {
            Logger.warn("License keys are found in both system properties and engine options. In this case, JxBrowser prefers the key from engine options.");
        }
        if (!fromOpts.isEmpty()) {
            return fromOpts;
        }
        return fromProps;
    }

    static {
        ClassPreLoader.ensureRequiredClassesLoaded();
        Environment.traceEnvironment();
    }
}

