/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.event.internal;

import com.teamdev.jxbrowser.event.Event;
import com.teamdev.jxbrowser.event.Observer;
import com.teamdev.jxbrowser.event.internal.SubscriptionImpl;
import com.teamdev.jxbrowser.internal.Preconditions;
import com.teamdev.jxbrowser.internal.Threads;
import com.teamdev.jxbrowser.logging.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class NewObservableHelper {
    private final Map<Observer, SubscriptionImpl> subscriptions = new ConcurrentHashMap<Observer, SubscriptionImpl>();

    public <E extends Event> SubscriptionImpl addObserver(Observer<E> observer) {
        Preconditions.checkNotNull(observer);
        if (!this.subscriptions.containsKey(observer)) {
            this.subscriptions.put(observer, this.newSubscription(observer));
        }
        return this.subscriptions.get(observer);
    }

    private <E extends Event> SubscriptionImpl newSubscription(final Observer<E> observer) {
        return new SubscriptionImpl(){

            @Override
            public void unsubscribe() {
                if (!this.isUnsubscribed()) {
                    NewObservableHelper.this.subscriptions.remove(observer);
                }
                super.unsubscribe();
            }
        };
    }

    public <E extends Event> void notifyObservers(E event) {
        for (Observer observer : this.observers()) {
            try {
                observer.on(event);
            }
            catch (Exception e) {
                Threads.reportException(e);
                Logger.warn("An exception has been thrown during observers notification", e);
            }
        }
    }

    private List<Observer> observers() {
        return new ArrayList<Observer>(this.subscriptions.keySet());
    }

    public boolean hasSubscribers() {
        return !this.subscriptions.isEmpty();
    }

    public void unsubscribeAll() {
        HashMap<Observer, SubscriptionImpl> subscribers = new HashMap<Observer, SubscriptionImpl>(this.subscriptions);
        for (Map.Entry entry : subscribers.entrySet()) {
            ((SubscriptionImpl)entry.getValue()).unsubscribe();
        }
    }
}

