/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.extensions.internal;

import com.teamdev.jxbrowser.browser.internal.BrowserImpl;
import com.teamdev.jxbrowser.deps.com.google.protobuf.BoolValue;
import com.teamdev.jxbrowser.deps.com.google.protobuf.StringValue;
import com.teamdev.jxbrowser.event.Observer;
import com.teamdev.jxbrowser.event.Subscription;
import com.teamdev.jxbrowser.extensions.Extension;
import com.teamdev.jxbrowser.extensions.ExtensionAction;
import com.teamdev.jxbrowser.extensions.ExtensionActionType;
import com.teamdev.jxbrowser.extensions.event.ExtensionActionEvent;
import com.teamdev.jxbrowser.extensions.internal.rpc.ExtensionActionStub;
import com.teamdev.jxbrowser.extensions.internal.rpc.ExtensionActionTypeResponse;
import com.teamdev.jxbrowser.internal.CloseableImpl;
import com.teamdev.jxbrowser.internal.Preconditions;
import com.teamdev.jxbrowser.internal.rpc.ExtensionActionId;
import com.teamdev.jxbrowser.internal.rpc.ExtensionId;
import com.teamdev.jxbrowser.internal.rpc.ServiceConnection;
import com.teamdev.jxbrowser.internal.rpc.ServiceConnectionImpl;
import com.teamdev.jxbrowser.ui.Bitmap;

public class ExtensionActionImpl
extends CloseableImpl
implements ExtensionAction {
    private final Extension extension;
    private final ExtensionActionId id;
    private final ServiceConnection<ExtensionActionStub> rpc;

    public ExtensionActionImpl(BrowserImpl browser, Extension extension) {
        this.extension = extension;
        this.id = ExtensionActionId.newBuilder().setExtensionId(ExtensionId.newBuilder().setValue(extension.id()).setProfileId(browser.profile().id()).build()).setBrowserId(browser.id()).build();
        this.rpc = new ServiceConnectionImpl<ExtensionActionStub>(this.id, browser.connection(), ExtensionActionStub::new);
    }

    @Override
    public Extension extension() {
        return this.extension;
    }

    @Override
    public Bitmap icon() {
        this.checkNotClosed();
        return (Bitmap)this.rpc.invoke(this.rpc.stub()::getIcon, this.id);
    }

    @Override
    public String tooltip() {
        this.checkNotClosed();
        return ((StringValue)this.rpc.invoke(this.rpc.stub()::getTooltip, this.id)).getValue();
    }

    @Override
    public String badge() {
        this.checkNotClosed();
        return ((StringValue)this.rpc.invoke(this.rpc.stub()::getBadge, this.id)).getValue();
    }

    @Override
    public ExtensionActionType type() {
        this.checkNotClosed();
        return ((ExtensionActionTypeResponse)this.rpc.invoke(this.rpc.stub()::getType, this.id)).getType().toPublic();
    }

    @Override
    public boolean isEnabled() {
        this.checkNotClosed();
        return ((BoolValue)this.rpc.invoke(this.rpc.stub()::isEnabled, this.id)).getValue();
    }

    @Override
    public void click() {
        this.checkNotClosed();
        Preconditions.checkState(this.isEnabled());
        this.rpc.invoke(this.rpc.stub()::click, this.id);
    }

    @Override
    public <E extends ExtensionActionEvent> Subscription on(Class<E> eventClass, Observer<E> observer) {
        return this.rpc.on(eventClass, observer);
    }
}

