/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.frame.internal;

import com.teamdev.jxbrowser.dom.internal.rpc.ClearStorageRequest;
import com.teamdev.jxbrowser.dom.internal.rpc.ClearStorageResponse;
import com.teamdev.jxbrowser.dom.internal.rpc.GetItemRequest;
import com.teamdev.jxbrowser.dom.internal.rpc.GetItemResponse;
import com.teamdev.jxbrowser.dom.internal.rpc.GetKeyRequest;
import com.teamdev.jxbrowser.dom.internal.rpc.GetKeyResponse;
import com.teamdev.jxbrowser.dom.internal.rpc.GetLengthRequest;
import com.teamdev.jxbrowser.dom.internal.rpc.GetLengthResponse;
import com.teamdev.jxbrowser.dom.internal.rpc.RemoveItemRequest;
import com.teamdev.jxbrowser.dom.internal.rpc.RemoveItemResponse;
import com.teamdev.jxbrowser.dom.internal.rpc.ReturnValue;
import com.teamdev.jxbrowser.dom.internal.rpc.SetItemRequest;
import com.teamdev.jxbrowser.dom.internal.rpc.SetItemResponse;
import com.teamdev.jxbrowser.dom.internal.rpc.StorageType;
import com.teamdev.jxbrowser.dom.internal.rpc.WebStorageStub;
import com.teamdev.jxbrowser.frame.WebStorage;
import com.teamdev.jxbrowser.frame.WebStorageException;
import com.teamdev.jxbrowser.frame.WebStorageOverflowException;
import com.teamdev.jxbrowser.frame.WebStorageSecurityException;
import com.teamdev.jxbrowser.internal.CloseableImpl;
import com.teamdev.jxbrowser.internal.Preconditions;
import com.teamdev.jxbrowser.internal.rpc.FrameId;
import com.teamdev.jxbrowser.internal.rpc.ServiceConnectionImpl;
import com.teamdev.jxbrowser.internal.rpc.transport.Connection;
import com.teamdev.jxbrowser.js.internal.rpc.ExceptionType;
import com.teamdev.jxbrowser.js.internal.rpc.JsError;
import java.util.Optional;

public final class WebStorageImpl
extends CloseableImpl
implements WebStorage {
    private final FrameId frameId;
    private final StorageType storageType;
    private final ServiceConnectionImpl<WebStorageStub> rpc;

    WebStorageImpl(Connection connection, StorageType storageType, FrameId frameId) {
        Preconditions.checkNotNull(connection);
        Preconditions.checkNotNull(storageType);
        Preconditions.checkNotNull(frameId);
        this.frameId = frameId;
        this.storageType = storageType;
        this.rpc = new ServiceConnectionImpl<WebStorageStub>(frameId, connection, WebStorageStub::new);
    }

    private static void throwWebStorageException(JsError error) {
        if (error.getExceptionType() == ExceptionType.SECURITY_ERROR) {
            throw new WebStorageSecurityException(error.getMessage());
        }
        if (error.getExceptionType() == ExceptionType.QUOTA_EXCEEDED_ERROR) {
            throw new WebStorageOverflowException(error.getMessage());
        }
        throw new WebStorageException(error.getMessage());
    }

    @Override
    public int length() {
        this.checkNotClosed();
        GetLengthRequest request = GetLengthRequest.newBuilder().setFrameId(this.frameId).setStorageType(this.storageType).build();
        GetLengthResponse response = (GetLengthResponse)this.rpc.invoke(this.rpc.stub()::getLength, request);
        if (response.getValueCase() == GetLengthResponse.ValueCase.LENGTH) {
            return response.getLength();
        }
        if (response.getValueCase() == GetLengthResponse.ValueCase.ERROR) {
            WebStorageImpl.throwWebStorageException(response.getError());
        }
        throw new WebStorageException("An invalid response is received from the engine.");
    }

    @Override
    public Optional<String> key(int index) {
        Preconditions.checkArgument(index >= 0 && index < this.length(), "The index must be in range: 0 <= index < length.", new Object[0]);
        this.checkNotClosed();
        GetKeyRequest request = GetKeyRequest.newBuilder().setFrameId(this.frameId).setStorageType(this.storageType).setIndex(index).build();
        GetKeyResponse response = (GetKeyResponse)this.rpc.invoke(this.rpc.stub()::getKey, request);
        if (response.getValueCase() == GetKeyResponse.ValueCase.KEY) {
            ReturnValue key = response.getKey();
            if (key.getValueCase() == ReturnValue.ValueCase.STRING_VALUE) {
                return Optional.of(key.getStringValue());
            }
            if (key.getValueCase() == ReturnValue.ValueCase.NULL_VALUE) {
                return Optional.empty();
            }
        }
        if (response.getValueCase() == GetKeyResponse.ValueCase.ERROR) {
            WebStorageImpl.throwWebStorageException(response.getError());
        }
        throw new WebStorageException("An invalid response is received from the engine.");
    }

    @Override
    public Optional<String> item(String key) {
        Preconditions.checkNotNull(key);
        this.checkNotClosed();
        GetItemRequest request = GetItemRequest.newBuilder().setFrameId(this.frameId).setStorageType(this.storageType).setKey(key).build();
        GetItemResponse response = (GetItemResponse)this.rpc.invoke(this.rpc.stub()::getItem, request);
        if (response.getValueCase() == GetItemResponse.ValueCase.ITEM) {
            ReturnValue item = response.getItem();
            if (item.getValueCase() == ReturnValue.ValueCase.STRING_VALUE) {
                return Optional.of(item.getStringValue());
            }
            if (item.getValueCase() == ReturnValue.ValueCase.NULL_VALUE) {
                return Optional.empty();
            }
        }
        if (response.getValueCase() == GetItemResponse.ValueCase.ERROR) {
            WebStorageImpl.throwWebStorageException(response.getError());
        }
        throw new WebStorageException("An invalid response is received from the engine.");
    }

    @Override
    public void putItem(String key, String value) {
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(value);
        this.checkNotClosed();
        SetItemRequest request = SetItemRequest.newBuilder().setFrameId(this.frameId).setStorageType(this.storageType).setKey(key).setValue(value).build();
        SetItemResponse response = (SetItemResponse)this.rpc.invoke(this.rpc.stub()::setItem, request);
        if (response.getValueCase() == SetItemResponse.ValueCase.ERROR) {
            WebStorageImpl.throwWebStorageException(response.getError());
        }
        if (response.getValueCase() != SetItemResponse.ValueCase.SUCCESS) {
            throw new WebStorageException("An invalid response is received from the engine.");
        }
    }

    @Override
    public void removeItem(String key) {
        Preconditions.checkNotNull(key);
        this.checkNotClosed();
        RemoveItemRequest request = RemoveItemRequest.newBuilder().setFrameId(this.frameId).setStorageType(this.storageType).setKey(key).build();
        RemoveItemResponse response = (RemoveItemResponse)this.rpc.invoke(this.rpc.stub()::removeItem, request);
        if (response.getValueCase() == RemoveItemResponse.ValueCase.ERROR) {
            WebStorageImpl.throwWebStorageException(response.getError());
        }
        if (response.getValueCase() != RemoveItemResponse.ValueCase.SUCCESS) {
            throw new WebStorageException("An invalid response is received from the engine.");
        }
    }

    @Override
    public void clear() {
        this.checkNotClosed();
        ClearStorageRequest request = ClearStorageRequest.newBuilder().setFrameId(this.frameId).setStorageType(this.storageType).build();
        ClearStorageResponse response = (ClearStorageResponse)this.rpc.invoke(this.rpc.stub()::clear, request);
        if (response.getValueCase() == ClearStorageResponse.ValueCase.ERROR) {
            WebStorageImpl.throwWebStorageException(response.getError());
        }
        if (response.getValueCase() != ClearStorageResponse.ValueCase.SUCCESS) {
            throw new WebStorageException("An invalid response is received from the engine.");
        }
    }

    @Override
    public boolean contains(String key) {
        Preconditions.checkNotNull(key);
        return this.item(key).isPresent();
    }
}

