/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.frame.internal.convert;

import com.teamdev.jxbrowser.frame.internal.convert.JavaValue;
import com.teamdev.jxbrowser.internal.Preconditions;
import com.teamdev.jxbrowser.internal.reflect.PrimitiveToWrapper;
import com.teamdev.jxbrowser.internal.rpc.JsObjectId;
import com.teamdev.jxbrowser.js.internal.JsArrayBufferImpl;
import com.teamdev.jxbrowser.js.internal.JsArrayImpl;
import com.teamdev.jxbrowser.js.internal.JsContext;
import com.teamdev.jxbrowser.js.internal.JsFunctionImpl;
import com.teamdev.jxbrowser.js.internal.JsMapImpl;
import com.teamdev.jxbrowser.js.internal.JsObjectImpl;
import com.teamdev.jxbrowser.js.internal.JsPromiseImpl;
import com.teamdev.jxbrowser.js.internal.JsSetImpl;
import com.teamdev.jxbrowser.js.internal.rpc.JsValue;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

abstract class AbstractValue
implements JavaValue {
    private static final Map<Class<? extends JsObjectImpl>, JsObjectConstructor> constructors;
    private final JsValue jsValue;

    AbstractValue(JsValue jsValue) {
        this.jsValue = jsValue;
    }

    <T extends JsObjectImpl> T getOrCreateJsObject(JsObjectId objectId, Class<T> type) {
        JsContext context = JsContext.of(objectId.getPageContextId());
        return (T)context.findJsObject(objectId, type).orElseGet(() -> {
            Preconditions.checkState(constructors.containsKey(type), "The type is not supported: %s", type);
            JsObjectImpl object = constructors.get(type).newInstance(context, objectId);
            context.registerJsObject(object);
            return object;
        });
    }

    JsValue jsValue() {
        return this.jsValue;
    }

    abstract List<Class<?>> destinationTypes();

    @Override
    public <T> T toObject() {
        return this.toObject(this.destinationTypes().get(0));
    }

    @Override
    public boolean isConvertibleTo(Class<?> type) {
        Preconditions.checkNotNull(type);
        if (type.isPrimitive()) {
            type = new PrimitiveToWrapper().apply(type);
        }
        for (Class<?> destinationType : this.destinationTypes()) {
            if (!type.isAssignableFrom(destinationType)) continue;
            return true;
        }
        return false;
    }

    static {
        HashMap<Class<JsSetImpl>, JsObjectConstructor> map = new HashMap<Class<JsSetImpl>, JsObjectConstructor>();
        map.put(JsObjectImpl.class, JsObjectImpl::new);
        map.put(JsArrayBufferImpl.class, JsArrayBufferImpl::new);
        map.put(JsArrayImpl.class, JsArrayImpl::new);
        map.put(JsFunctionImpl.class, JsFunctionImpl::new);
        map.put(JsMapImpl.class, JsMapImpl::new);
        map.put(JsPromiseImpl.class, JsPromiseImpl::new);
        map.put(JsSetImpl.class, JsSetImpl::new);
        constructors = Map.copyOf(map);
    }

    @FunctionalInterface
    static interface JsObjectConstructor {
        public JsObjectImpl newInstance(JsContext var1, JsObjectId var2);
    }
}

