/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.frame.internal.convert;

import com.teamdev.jxbrowser.frame.internal.convert.BigInt;
import com.teamdev.jxbrowser.frame.internal.convert.JavaValue;
import com.teamdev.jxbrowser.frame.internal.convert.NumberValue;
import com.teamdev.jxbrowser.internal.Preconditions;
import com.teamdev.jxbrowser.js.internal.rpc.JsValue;
import com.teamdev.jxbrowser.js.internal.rpc.NumberValue;
import java.math.BigInteger;
import java.util.List;

final class BigIntValue
extends NumberValue
implements JavaValue {
    BigIntValue(JsValue jsValue) {
        super(jsValue);
        Preconditions.checkArgument(jsValue.getValueCase() == JsValue.ValueCase.NUMBER_VALUE);
        Preconditions.checkArgument(jsValue.getNumberValue().getValueCase() == NumberValue.ValueCase.BIG_INT_VALUE);
    }

    @Override
    public List<Class<?>> destinationTypes() {
        return List.of(BigInteger.class);
    }

    @Override
    public <T> T toObject(Class<?> type) {
        Preconditions.checkNotNull(type);
        Preconditions.checkArgument(this.isConvertibleTo(type) && !type.isPrimitive(), "Cannot convert the value to: %s", type);
        return (T)BigInt.toJava(this.jsValue().getNumberValue().getBigIntValue());
    }
}

